#pragma once

#include <rtline/library/deprecated/async_impl/async_impl.h>

class TBillingClientConfig: public TAsyncApiImpl::TConfig {
    R_READONLY(TString, RequestPolicyName);
    R_READONLY(TDuration, RequestTimeout, TDuration::Seconds(1));
    R_READONLY(TDuration, HoldInterval, TDuration::Days(3));

    R_READONLY(TString, PaymentPath, "trust-payments/v2/payments");
    R_READONLY(TString, PaymentMethodsPath, "trust-payments/v2/payment-methods");
    R_READONLY(TString, OrdersPath, "trust-payments/v2/orders");
    R_READONLY(TString, RefundsPath, "trust-payments/v2/refunds");
    R_READONLY(TString, YAccountPath, "trust-payments/v2/account");
    R_READONLY(TString, TopupPath, "trust-payments/v2/topup");

    R_READONLY(ui32, ServerThreads, 8);
    R_READONLY(ui32, Threads, 8);

public:
    void Init(const TYandexConfig::Section* section, const TMap<TString, NSimpleMeta::TConfig>* requestPolicy);
    void ToString(IOutputStream& os) const;

    static TBillingClientConfig ParseFromString(const TString& configStr) {
        return TAsyncApiImpl::TConfig::ParseFromString<TBillingClientConfig>(configStr);
    }
};
