#pragma once

#include <drive/library/cpp/trust/trust_cache.h>

#include <drive/backend/billing/client/client.h>
#include <drive/backend/billing/interfaces/account_record.h>
#include <drive/backend/billing/interfaces/entities.h>
#include <drive/backend/billing/interfaces/logic.h>

#include <drive/backend/database/history/config.h>

#include <rtline/util/types/accessor.h>

#include <util/generic/vector.h>

class TBillingConfig {
    R_READONLY(ui32, MinimalPayment, 314);
    R_READONLY(TString, NotifierName);
    R_READONLY(ui32, ClearingTasksAtOnce, 15);
    R_READONLY(TDuration, FailedTaskCheckInterval, TDuration::Zero());
    R_READONLY(TDuration, ErrorTaskCheckInterval, TDuration::Minutes(30));
    R_READONLY(TDuration, PaymentsCacheInterval, TDuration::Hours(6));
    R_READONLY(TDuration, RefreshInterval, TDuration::Seconds(1));
    R_READONLY(TDuration, MaxAutoCheckDebtDeep, TDuration::Days(40));
    R_READONLY(bool, BatchUpdates, true);
    R_READONLY(THistoryConfig, AccountsHistoryConfig, {});

    R_READONLY(EBillingQueue, ActiveQueue, EBillingQueue::Active);
    R_READONLY(EBillingQueue, AlternativeQueue, EBillingQueue::Prestable);
    R_READONLY(TVector<ILogicConfig::TPtr>, LogicConfigs, {});
    R_READONLY(TDuration, OperationTimeout, TDuration::Hours(3));

    R_READONLY(NDrive::NBilling::EAccount, TrustCacheStorageLogic, NDrive::NBilling::EAccount::Trust);

    R_READONLY(bool, UseDBJsonStatements, true);
    R_READONLY(bool, UsePaymentsCache, false);

public:
    void Init(const TYandexConfig::Section* section, const TMap<TString, NSimpleMeta::TConfig>* requestPolicy);
    void ToString(IOutputStream& os) const;

    static TBillingConfig ParseFromString(const TString& configStr) {
        TBillingConfig result;
        TAnyYandexConfig config;
        CHECK_WITH_LOG(config.ParseMemory(configStr.data()));
        result.Init(config.GetRootSection(), nullptr);
        return result;
    }

    NDrive::ITrustStorageConfig* GetTrustStorageConfig() const {
        return TrustStorageConfig.Get();
    }

private:
    THolder<NDrive::ITrustStorageConfig> TrustStorageConfig;
};
