#pragma once

#include <drive/backend/billing/interfaces/entities.h>

#include <drive/library/cpp/yt/common/writer.h>


namespace NBillingExports {

    TString GetStringSum(ui32 sum, bool isRefund);
    TString GetOrderType(EBillingType bType);
    NYT::TNode CreateTransactionNodeBase(const TString& orderId, const TString& clientId, const TString& type, const TString& paymentType, const TString& serviceOrderId = "");

    template<class TTaskType>
    NYT::TNode CreateRefundNode(const TTaskType& paymentTask, const TString& clientId, ui32 refundSum, const TString& type) {
        NYT::TNode transactionRefundNode = CreateTransactionNodeBase(paymentTask.GetSessionId(), clientId, type, "card");
        TInstant ts = paymentTask.GetLastUpdate();
        transactionRefundNode["dt"] = ToString(ts);
        transactionRefundNode["total_sum"] = GetStringSum(refundSum, true);
        transactionRefundNode["commission_sum"] = "0.0";
        transactionRefundNode["promocode_sum"] = "0.0";
        return transactionRefundNode;
    }

    NYT::TNode CreateRefundNode(const TString& orderId, const TString& serviceOrderId, const TString& clientId, ui32 refundSum, const TString& type, TInstant ts);

    NYT::TNode CreateTransactionNode(const TString& sessionId, const TString& clientId,
        ui32 totalSum,
        ui32 bonusSum,
        const TInstant& ts,
        const TString& type,
        const bool isRefund,
        const TString& externalId = "",
        const TString& paymentType = "card");

    NYT::TNode CreateCashbackTransactionNode(const TString& sessionId, const TString& clientId,
        ui32 totalSum,
        ui32 bonusSum,
        const TInstant& ts,
        const TString& type,
        const bool isRefund,
        const TString& externalId = "",
        const TString& paymentType = "yandex_account_topup");

    NYT::TNode CreateB2BTransactionNode(const TString& sessionId, const TString& clientId,
        ui32 totalSum,
        ui32 bonusSum,
        const TInstant& ts,
        const TString& type,
        const bool isRefund,
        const TString& externalId = "",
        const TString& paymentType = "card");

    class ISalaryExportContext {
    public:
        virtual const TString& GetBalanceServiceID() const = 0;
        virtual const TString& GetBalancePaymentType() const = 0;
        virtual const TString& GetBalancePartnerID() const = 0;
        virtual const TString& GetBalanceProduct() const = 0;
        virtual ~ISalaryExportContext() {}
    };


    NYT::TNode CreateSalaryNode(const TString& orderId, const ISalaryExportContext& context, const TString& clientId, TInstant ts, ui32 sum);
    NYT::TNode CreateSalaryNode(const TString& transactionId, const TString& orderId, const ISalaryExportContext& context, const TString& clientId, TInstant ts, ui32 sum);

}
