#include "account_record.h"

template <>
bool NJson::TryFromJson<NDrive::NBilling::TLimitedBalance>(const NJson::TJsonValue& value, NDrive::NBilling::TLimitedBalance& result) {
    return result.Parse(value);
}

template <>
NJson::TJsonValue NJson::ToJson<NDrive::NBilling::TLimitedBalance>(const NDrive::NBilling::TLimitedBalance& object) {
    return object.ToJson();
}

NDrive::NBilling::TAccountsHistoryManager::TOptionalEvents NDrive::NBilling::TAccountsHistoryManager::GetEventsByAccountId(const ui32 id, TRange<TInstant> timestampRange, const TMaybe<TString>& historyComment, NDrive::TEntitySession& session, ui64 limit, ui64 offset) const {
    TQueryOptions options(limit, true, offset);
    options.AddGenericCondition("account_id", ::ToString(id));
    if (historyComment) {
        options.AddGenericCondition("history_comment", *historyComment);
    }
    return TBase::GetEvents({}, timestampRange, session, options);
}
