#pragma once

#include "history.h"
#include "tasks.h"

namespace NDrive::NBilling {
    class TActiveTasksManager : public TDatabaseSessionConstructor {
    protected:
    public:
        TActiveTasksManager(const IHistoryContext& context, bool useDBJsonStatements)
            : TDatabaseSessionConstructor(context.GetDatabase())
            , HistoryManager(context, useDBJsonStatements)
            , Table(GetDatabase().GetTable("billing_tasks"))
        {
        }

    public:
        const TBillingHistoryManager& GetHistoryManager() const {
            return HistoryManager;
        }

        TOptionalBillingTask GetTask(const TString& sessionId, NDrive::TEntitySession& session) const;
        TOptionalBillingTasks GetTasks(NDrive::TEntitySession& session, const TString& condition = "") const;
        TOptionalBillingTasks GetUsersTasks(TConstArrayRef<TString> users, NDrive::TEntitySession& session) const;
        TOptionalBillingTasks GetSessionsTasks(TConstArrayRef<TString> sessions, NDrive::TEntitySession& session) const;

        bool BoostSession(const TString& sessionId, const TString& historyUserId, const TBillingTask::TExecContext& context, NDrive::TEntitySession& session) const;
        TOptionalBillingTasks BoostUserSessions(const TString& userId, const TString& historyUserId, const TBillingTask::TExecContext& context, NDrive::TEntitySession& session) const;

        bool CancelTask(const TString& sessionId, const TString& historyUserId, NDrive::TEntitySession& session, ui32 cancelSum = 0) const;
        bool CancelTask(const TBillingTask& task, const TString& historyUserId, NDrive::TEntitySession& session, ui32 cancelSum = 0) const;
        TOptionalBillingTasks Update(const NStorage::TTableRecord& condition, const NStorage::TTableRecord& update, NDrive::TEntitySession& session) const;
        TOptionalBillingTasks UpdateWithHistory(const NStorage::TTableRecord& condition, const NStorage::TTableRecord& update, const TString& historyUserId, NDrive::TEntitySession& session) const;

    private:
        TOptionalBillingTasks GetTasks(const TString& field, TConstArrayRef<TString> ids, NDrive::TEntitySession& session) const;
        TOptionalBillingTasks BoostTasks(NStorage::TTableRecord&& condition, const TString& historyUserId, const TBillingTask::TExecContext& context, NDrive::TEntitySession& session) const;

    private:
        TBillingHistoryManager HistoryManager;
        NStorage::ITableAccessor::TPtr Table;
    };
}

class TRefundsDB: public IBaseSequentialTableImpl {
public:
    TRefundsDB(const IHistoryContext& context);

    bool GetSessionsRefunds(TConstArrayRef<TString> sessionIds, TMap<TString, TVector<TRefundTask>>& refunds, NDrive::TEntitySession& session) const;
    bool GetSessionRefunds(const TString& sessionIds, TVector<TRefundTask>& refunds, NDrive::TEntitySession& session) const;

    TVector<TRefundTask> GetRefundsFromDB(const TSet<TString>& statuses, NDrive::TEntitySession& session) const;

protected:
    TString GetSeqFieldName() const override {
        return "id";
    }

    TString GetTimestampFieldName() const override {
        return "last_update_ts";
    }
};
