#pragma once

#include <rtline/library/storage/structured.h>

class TPromocodeAccountLink {
    R_FIELD(TString, Promocode);
    R_FIELD(ui32, AccountId, Max<ui32>());
    R_FIELD(TString, UserId);

public:
    class TDecoder : public TBaseDecoder {
    public:
        R_FIELD(i32, Promocode, -1);
        R_FIELD(i32, AccountId, -1);
        R_FIELD(i32, UserId, -1);

    public:
        TDecoder() = default;
        TDecoder(const TMap<TString, ui32>& decoderBase, const bool strict = true)
            : TBaseDecoder(strict) {
            Promocode = GetFieldDecodeIndex("promocode", decoderBase);
            AccountId = GetFieldDecodeIndex("account_id", decoderBase);
            UserId = GetFieldDecodeIndex("user_id", decoderBase);
        }
    };

    bool DeserializeWithDecoder(const TDecoder& decoder, const TConstArrayRef<TStringBuf>& values, const IHistoryContext* /*hContext*/) {
        READ_DECODER_VALUE(decoder, values, Promocode);
        READ_DECODER_VALUE(decoder, values, AccountId);
        if (decoder.GetUserId() != -1) {
            READ_DECODER_VALUE(decoder, values, UserId);
        }
        return true;
    }

    NStorage::TTableRecord SerializeToTableRecord() const {
        return NStorage::TRecordBuilder("promocode", Promocode)("account_id", AccountId)("user_id", UserId);
    }

    void DoBuildReportItem(NJson::TJsonValue& json) const {
        json.InsertValue("promocode", Promocode);
        json.InsertValue("account_id", AccountId);
        json.InsertValue("user_id", UserId);
    }

    static TString GetTableName() {
        return "promocode_account_links";
    }
};
