#pragma once

#include "entities.h"

#include <drive/library/cpp/wait_guard/wait_guard.h>

#include <rtline/library/unistat/signals.h>
#include <rtline/util/types/accessor.h>

enum class EDriveOpResult {
    Ok = 0,
    LogicError = 1,
    TransactionError = 2
};

enum class EProduceResult {
    Ok /* "ok" */,
    Wait /* "wait" */,
    Error /* "error" */,
    TransactionError /* "transaction_error" */
};

enum class ERefreshStatus {
    Ok /* "ok" */,
    Skip /* "skip" */,
    Error /* "error" */,
};

class TLazySession {
public:
    TLazySession(TDatabasePtr database, TAtomicSharedPtr<NDrive::ISessionContext> context = nullptr)
        : Database(database)
        , Context(context) {}

    TLazySession(NDrive::TEntitySession& session)
        : ExternalSession(&session) {}

    ~TLazySession() noexcept(false) {
    }

    NDrive::TEntitySession& Get() {
        if (ExternalSession) {
            return *ExternalSession;
        }
        if (!Session) {
            Session = NDrive::TEntitySession(Database->CreateTransaction(false), Context);
        }
        return Session;
    }

    bool Commit() {
        if (Session) {
            if (Session.Commit()) {
                Session = {};
            } else {
                return false;
            }
        }
        return true;
    }

    void Clear() {
        Session = {};
    }

private:
    TDatabasePtr Database;
    TAtomicSharedPtr<NDrive::ISessionContext> Context;
    NDrive::TEntitySession Session;
    NDrive::TEntitySession* ExternalSession = nullptr;
};
