#pragma once

#include <drive/backend/billing/trust/charge_logic.h>

class TMobilePaymentLogicConfig : public ITrustLogicConfig {
    static TFactory::TRegistrator<TMobilePaymentLogicConfig> Registrator;

public:
    virtual IChargeLogic::TPtr ConstructLogic(const ISettings& /*settings*/, TUsersDB& /*users*/, TAtomicSharedPtr<NDrive::INotifier> notifier) const override;
    NDrive::NBilling::EAccount GetType() const override {
        return NDrive::NBilling::EAccount::MobilePayment;
    }
};

class TMobilePaymentLogic : public TTrustLogic {
    using TBase = TTrustLogic;
public:
    using TBase::TBase;
    virtual TExpectedCharge ProducePayments(NDrive::NBilling::IBillingAccount::TPtr account, const TPaymentsData& snapshot, const TPaymentsManager& paymentsManager, const TChargeInfo& chargeInfo, TLazySession& session, const bool /*sync*/) const override;
    virtual TChargeInfo CorrectCharge(const NDrive::NBilling::IBillingAccount::TPtr account, const TPaymentsData& snapshot, const TChargeInfo& chargeInfo) const override;
};
