#pragma once

#include <drive/library/cpp/trust/trust_cache.h>

#include <library/cpp/threading/future/core/future.h>
#include <library/cpp/yconf/conf.h>

#include <rtline/library/storage/redis/abstract.h>

#include <util/datetime/base.h>
#include <util/generic/ptr.h>

namespace NDriveRedis {
namespace NCache {

struct TTrustRedisStorageOptions : public NDrive::ITrustStorageOptions {
    TAtomicSharedPtr<NDriveRedis::NKVAbstract::TRedisVersionedStorage> Storage;

public:
    TTrustRedisStorageOptions(TAtomicSharedPtr<NDriveRedis::NKVAbstract::TRedisVersionedStorage> storage) : Storage(storage)
    {
    }
};  // class TTrustRedisStorageOptions

class TTrustRedisCacheConfig : public NDrive::ITrustStorageConfig {
    using TBase = NDrive::ITrustStorageConfig;
public:
    using TBase::TBase;

    THolder<NDrive::ITrustStorage> Construct(THolder<NDrive::ITrustStorageOptions>&& ops, THolder<NDrive::ITrustUpdater>&& updater) const override;

    void Init(const TYandexConfig::Section* section) override;
    void ToString(IOutputStream& os) const override;
    TString GetExternalDBName() const;

private:
    static TFactory::TRegistrator<TTrustRedisCacheConfig> Registrator;

    R_READONLY(TString, DBName, "None");
};  // class TTrustRedisCacheConfig

class TTrustRedisCache : public NDrive::ITrustStorage {
public:
    TTrustRedisCache(TAtomicSharedPtr<NDriveRedis::NKVAbstract::TRedisVersionedStorage> cache, const TTrustRedisCacheConfig& storageConfig,
                     THolder<NDrive::ITrustUpdater>&& updater);

private:
    bool GetValue(const TString& key, TString& result) const;
    bool SetTTLValue(const TString& key, const TTimedMethods& payments);

    NThreading::TFuture<TTimedMethods> GetTimedPayments(const TString& userId) const override;
    void DoUpdateValue(const TString& userId, const TTimedMethods& payments) override;

private:
    TAtomicSharedPtr<NDriveRedis::NKVAbstract::TRedisVersionedStorage> Cache;
    TString CacheId;
};  // class TTrustRedisStorage

}  // namespace NDriveRedis::NCache
}  // namespace NDriveRedis
