#pragma once

#include <drive/library/cpp/trust/trust_cache.h>
#include <drive/library/cpp/redis/client.h>

#include <library/cpp/threading/future/core/future.h>
#include <library/cpp/yconf/conf.h>


#include <util/datetime/base.h>
#include <util/generic/ptr.h>

namespace NDrive::NRedis::NCache {

    class TTrustStorageOptions : public ITrustStorageOptions {
    public:
        // Empty
    };

    class TTrustCacheConfig : public NDrive::ITrustStorageConfig {
        using TBase = NDrive::ITrustStorageConfig;

    public:
        using TBase::TBase;

        THolder<NDrive::ITrustStorage> Construct(THolder<NDrive::ITrustStorageOptions>&& ops, THolder<NDrive::ITrustUpdater>&& updater) const override;

        void Init(const TYandexConfig::Section* section) override;
        void ToString(IOutputStream& os) const override;

        const TConfig& GetClientConfig() const;

    private:
        static TFactory::TRegistrator<TTrustCacheConfig> Registrator;

        TConfig ClientConfig;
    };

    class TTrustCache : public NDrive::ITrustStorage {
    public:
        TTrustCache(const TTrustCacheConfig& storageConfig, THolder<NDrive::ITrustUpdater>&& updater);

    private:
        NThreading::TFuture<TTimedMethods> GetTimedPayments(const TString& userId) const override;
        void DoUpdateValue(const TString& userId, const TTimedMethods& payments) override;

    private:
        TString CacheId;
        TClient Cache;
    };

}
