#pragma once

#include <drive/backend/billing/interfaces/account.h>
#include <drive/backend/billing/interfaces/entities.h>

#include <drive/backend/users/user.h>

class TTrustAccountOld: public NDrive::NBilling::IBillingAccount, public NDrive::NBilling::ITrustAccount {
public:
    TTrustAccountOld(const TString& userId,
                    const NDrive::NBilling::TAccountDescriptionRecord& description,
                    NDrive::NBilling::TAccountRecord::TPtr accountRecord,
                    TDatabasePtr database,
                    const NDrive::NBilling::TAccountsHistoryManager& historyManager)
        : IBillingAccount(userId, description, accountRecord, nullptr, historyManager)
        , Database(database)
    {
    }

    static NDrive::NBilling::IBillingAccount::TPtr ConstructAccount(const TString& userId, TDatabasePtr database, const NDrive::NBilling::TAccountsHistoryManager& historyManager) {
        NStorage::TRecordBuilder fakeRecord;
        // account part
        fakeRecord("account_id", 0);
        fakeRecord("type_id", 0);
        fakeRecord("spent", 0);
        fakeRecord("version", 0);
        fakeRecord("active", "t");
        fakeRecord("created_at", Now().Seconds());
        fakeRecord("account_meta", "{\"default_card\":{\"suffix\":3350,\"code\":\"card-x9378\",\"prefix\":510000}}");


        NDrive::NBilling::TAccountRecord::TPtr accountRec = NDrive::NBilling::TAccountRecord::TFactory::Construct(NDrive::NBilling::EWalletDataType::Trust);
        CHECK_WITH_LOG(accountRec->DeserializeFromTableRecord(fakeRecord, nullptr));

        // description part
        NStorage::TRecordBuilder fakeDescription;
        fakeDescription("id", 0);
        fakeDescription("type", ::ToString(NDrive::NBilling::EAccount::Trust));
        fakeDescription("data_type", ::ToString(NDrive::NBilling::EWalletDataType::Trust));
        fakeDescription("name", "card");
        fakeDescription("hard_limit", 0);
        fakeDescription("soft_limit", 0);
        fakeDescription("meta", "{\"hr_name\": \"За свои\", \"selectable\": true}");

        NDrive::NBilling::TAccountDescriptionRecord description;
        CHECK_WITH_LOG(TBaseDecoder::DeserializeFromTableRecord(description, fakeDescription));
        return new TTrustAccountOld(userId, description, accountRec, database, historyManager);
    }

    i64 GetBalance() const override {
        return 0;
    }

    TString GetDefaultCard() const override {
        return "";
    }

    bool SetDefaultCard(const NDrive::NTrustClient::TPaymentMethod& /*defaultCard*/, const TString& /*historyUser*/, NDrive::TEntitySession& /*session*/) override {
        ERROR_LOG << "Deprecated" << Endl;
        return false;
    }

    virtual NJson::TJsonValue GetUserReport() const override {
        NJson::TJsonValue json;
        json["paymethod_id"] = "";
        json["pan"]["suffix"] = "0";
        json["pan"]["prefix"] = "0";
        return json;
    }

    virtual NJson::TJsonValue DoGetReport() const override {
        NJson::TJsonValue result(NJson::JSON_MAP);
        result["paymethod_id"] = "";
        result["card_mask"] = "0****0";
        return result;
    }

protected:
    virtual EDriveOpResult DoAdd(ui32 /*sum*/, NDrive::TEntitySession& /*session*/, TInstant /*deadline*/, const TString& /*comment*/) const override {
        return EDriveOpResult::LogicError;
    }
    virtual EDriveOpResult DoRemove(ui32 /*sum*/, NDrive::TEntitySession& /*session*/) const override {
        return EDriveOpResult::LogicError;
    }

private:
    TDatabasePtr Database;
};
