#pragma once

#include "callback.h"

#include <drive/backend/billing/client/charge_logic.h>
#include <drive/backend/billing/client/client.h>
#include <drive/backend/billing/interfaces/logic.h>
#include <drive/backend/billing/interfaces/tasks.h>

#include <util/generic/queue.h>

class TBillingClient;
class TDriveUserData;

class TTrustLogicConfig : public ITrustLogicConfig {
    static TFactory::TRegistrator<TTrustLogicConfig> Registrator;

public:
    virtual IChargeLogic::TPtr ConstructLogic(const ISettings& /*settings*/, TUsersDB& /*users*/, TAtomicSharedPtr<NDrive::INotifier> notifier) const override;
    NDrive::NBilling::EAccount GetType() const override {
        return NDrive::NBilling::EAccount::Trust;
    }
};

class TTrustLogic : public ITrustLogic {
protected:
    using TBase = ITrustLogic;
public:
    TTrustLogic(const ITrustLogicConfig& trustConfig, const ISettings& settings, TUsersDB& usersDB, TAtomicSharedPtr<NDrive::INotifier> notifier);
    virtual ~TTrustLogic();

    virtual EProduceResult SyncPayments(const TPaymentsData& snapshot, const TPaymentsManager& manager, const NDrive::NBilling::TAccountsManager& accountsManager, NDrive::ITrustStorage* cache, const bool sync) const override;
    virtual TExpectedCharge ProducePayments(NDrive::NBilling::IBillingAccount::TPtr account, const TPaymentsData& snapshot, const TPaymentsManager& paymentsManager, const TChargeInfo& chargeInfo, TLazySession& session, const bool /*sync*/) const override;
    virtual TChargeInfo CorrectCharge(const NDrive::NBilling::IBillingAccount::TPtr /*account*/, const TPaymentsData& /*snapshot*/, const TChargeInfo& chargeInfo) const override;

    void ProcessClearing(const TClearingTask& task, const TPaymentsManager& paymentsManager, const TDuration clearingInterval, NDrive::TEntitySession& session, TBillingSyncGuard& guard) const;
    void ProcessRefund(const TRefundTask& task, TBillingSyncGuard& guard, TSyncRefundCallback::TLogger&& callback) const;
    TDuration GetMimFailedMethodsAge() const;
    bool UseExtraUsers() const;
    ui32 SplitCharge(const TPaymentsData& snapshot, const ui32 sum) const;

    bool GetTrustInfo(EBillingType billingType, const TString& paymentId, NJson::TJsonValue& reply) const;
    TMaybe<NDrive::NTrustClient::TPaymentMethod> SetDefaultCard(NDrive::NBilling::IBillingAccount::TPtr account, const TString& payMethod, const TString& historyUser, NDrive::TEntitySession& session) const;

    bool IsSync() const override {
        return false;
    }
};


