#include "updater.h"

NThreading::TFuture<TVector<NDrive::NTrustClient::TPaymentMethod>> TTrustUpdater::GetPaymentMethods(const TString& userId) const {
    auto cards = TrustLogic->GetUserCards(userId);
    if (cards) {
        return NThreading::MakeFuture(*cards);
    }
    return NThreading::MakeErrorFuture<TVector<NDrive::NTrustClient::TPaymentMethod>>(std::make_exception_ptr(yexception() << "cannot fetch cards"));
}
