#pragma once
#include "charge_logic.h"

#include <drive/library/cpp/trust/trust_cache.h>


class TTrustUpdater : public NDrive::ITrustUpdater {
public:
    TTrustUpdater(IChargeLogic::TPtr logic) {
        LogicContainer = logic;
        TrustLogic = logic->GetAsSafe<TTrustLogic>();
    }

    virtual NThreading::TFuture<TVector<NDrive::NTrustClient::TPaymentMethod>> GetPaymentMethods(const TString& userId) const override;

private:
    IChargeLogic::TPtr LogicContainer;
    const TTrustLogic* TrustLogic;
};
