#pragma once

#include <drive/library/cpp/trust/trust_cache.h>

class TRTLineAPI;

struct TTrustRTYStorageOptions : public NDrive::ITrustStorageOptions {
    const TRTLineAPI* RtlineApi;

public:
    TTrustRTYStorageOptions(const TRTLineAPI* storage) : RtlineApi(storage)
    {
    }
};

class TRTYTrustStorageConfig : public NDrive::ITrustStorageConfig {
    R_READONLY(TString, APIName);

public:
    using NDrive::ITrustStorageConfig::ITrustStorageConfig;
    virtual void Init(const TYandexConfig::Section* section) override {
        NDrive::ITrustStorageConfig::Init(section);
        APIName = section->GetDirectives().Value("APIName", APIName);
    }
    void ToString(IOutputStream& os) const override {
        NDrive::ITrustStorageConfig::ToString(os);
        os << "APIName: " << APIName << Endl;
    }

    virtual THolder<NDrive::ITrustStorage> Construct(THolder<NDrive::ITrustStorageOptions>&& ops, THolder<NDrive::ITrustUpdater>&& updater) const override;

private:
    static TFactory::TRegistrator<TRTYTrustStorageConfig> Registrator;
};

class TRTYTrustStorage : public NDrive::ITrustStorage {
public:
    TRTYTrustStorage(const TRTLineAPI* storage, const TRTYTrustStorageConfig& config, THolder<NDrive::ITrustUpdater>&& updater)
        : NDrive::ITrustStorage(config, std::move(updater))
    {
        PaymentStorage = storage;
        CHECK_WITH_LOG(PaymentStorage);
    }

private:
    virtual void DoUpdateValue(const TString& userId, const TTimedMethods& payments) override;
    virtual NThreading::TFuture<TTimedMethods> GetTimedPayments(const TString& userId) const override;

private:
    const TRTLineAPI* PaymentStorage;
};
