#pragma once

#include <util/generic/string.h>

const TString DefaultSessionID = "fcded3db-c7be428c-4308b39f-30";
const TString DefaultSessionID1 = "fcded3db-c7be428c-4308b39f-31";
const TString DefaultUserId = "12789938-63f9-406d-8407-c4f7cf5d741c";
const TString UserWithoutCards = "7bab7f65-8862-488f-88b1-cdfac8c4e0ff";
const TString UserWith2Cards = "12789938-63f9-406d-8407-c4f7cf5d741c";
const TString UserWithYandexAccount = "b9f418dd-202e-4b97-b616-41a8f89d0359";
const TString UserWithFailedYandexAccount = "94c9653e-9f55-49f2-af8a-5156342bd9c8";
const TString RobotUserId = "94c9653e-9f55-49f2-af8a-5156342bd9c8";

const ui32 WalletHardLimit = 100000;
const ui32 WalletSoftLimit = 50000;
const ui32 NotAuthorizedSum = 109900;

const TString ReplyCard3350 = R"({
    "region_id": 225,
    "payment_method" : "card",
    "expiration_month" : "07",
    "binding_ts" : "1536324485.656",
    "id" : "card-x9378",
    "expired" : false,
    "card_bank" : "TINKOFF BANK",
    "system" : "VISA",
    "account" : "510000****3350",
    "expiration_year" : "2021"
})";


const TString ReplyCard0256 = R"({
    "region_id": 225,
    "payment_method" : "card",
    "expiration_month" : "07",
    "binding_ts" : "1536324485.656",
    "id" : "card-x12345",
    "expired" : false,
    "card_bank" : "TINKOFF BANK",
    "system" : "VISA",
    "account" : "510000****0256",
    "expiration_year" : "2021"
})";

const TString ReplyNoCard = R"({
    "status": "success",
    "bound_payment_methods" : []
})";

const TString ReplyTwoCards = R"({
    "status": "success",
    "bound_payment_methods": [
    {
        "region_id": 225,
        "payment_method": "card",
        "expiration_month": "05",
        "binding_ts": "1529249352.069",
        "id": "card-x3366",
        "aliases": ["card-x5b0ab49cd951d24807c9215d", "card-x3366"],
        "expired": false,
        "card_bank": "RBS BANK (ROMANIA), S.A.",
        "system": "MasterCard", "recommended_verification_type": null, "orig_uid": "4006777567", "card_country": "ROU", "payment_system": "MasterCard",
        "card_level": "",
        "holder": "IVAN IVANOV",
        "binding_systems": ["trust"],
        "account": "510000****5974",
        "expiration_year": "2019",
        "card_id": "card-x5b0ab49cd951d24807c9215d"
    },
    {
        "region_id": 225,
        "payment_method": "card",
        "expiration_month": "09",
        "binding_ts": "1529321410.709",
        "id": "card-x9378",
        "aliases": ["card-x5b166315b63de61baf38067b", "card-x9378"],
        "expired": false,
        "card_bank": "RBS BANK (ROMANIA), S.A.",
        "system": "MasterCard", "recommended_verification_type": null, "orig_uid": "4006777567", "card_country": "ROU", "payment_system": "MasterCard",
        "card_level": "",
        "holder": "IVAN IVANOVICH",
        "binding_systems": ["trust"],
        "account": "510000****3350",
        "expiration_year": "2019",
        "card_id": "card-x5b166315b63de61baf38067b"
    }
    ]
})";

const TString YandexAccountId = "w/30b153cc-8e30-58e2-8d1a-1095bc49b915";

const TString ReplyWithYandexAccount = R"({
    "status": "success",
    "bound_payment_methods": [
    {
        "region_id": 225,
        "payment_method": "card",
        "expiration_month": "05",
        "binding_ts": "1529249352.069",
        "id": "card-x3366",
        "aliases": ["card-x5b0ab49cd951d24807c9215d", "card-x3366"],
        "expired": false,
        "card_bank": "RBS BANK (ROMANIA), S.A.",
        "system": "MasterCard", "recommended_verification_type": null, "orig_uid": "4006777567", "card_country": "ROU", "payment_system": "MasterCard",
        "card_level": "",
        "holder": "IVAN IVANOV",
        "binding_systems": ["trust"],
        "account": "510000****5974",
        "expiration_year": "2019",
        "card_id": "card-x5b0ab49cd951d24807c9215d"
    },
    {
      "payment_method" : "yandex_account",
      "account" : ")" + YandexAccountId + R"(",
      "payment_system" : null,
      "currency" : "RUB",
      "id" : "yandex_account-)" + YandexAccountId + R"(",
      "balance" : "251.27"
    }
    ]
})";

const TString ReplyCreateYandexAccount = R"({
    "status": "success",
    "payment_method_id" : "yandex_account-)" + YandexAccountId + R"("
})";

const TString ReplyFailedCreateYandexAccount = R"({
    "status": "fail",
    "error" : "cannot create account"
})";
