#pragma once

#include "constants.h"

#include <drive/backend/offers/abstract.h>

class TFakeOffer : public IOffer {
    virtual EDriveSessionResult DoCheckSession(const TUserPermissions& /*permissions*/, NDrive::TEntitySession& /*session*/, const NDrive::IServer* /*server*/, bool /*onPerform*/) const override;
    ui32 Deposit = 0;

public:
    TFakeOffer(ui32 deposit = 0);
    ui32 GetDeposit() const override;

protected:
    virtual NJson::TJsonValue DoBuildJsonReport(const TReportOptions& options, const ICommonOfferBuilderAction* constructor, const NDrive::IServer& server) const override;

public:
    virtual TOfferStatePtr Calculate(const TVector<IEventsSession<TCarTagHistoryEvent>::TTimeEvent>& /*timeline*/, const TVector<TAtomicSharedPtr<TCarTagHistoryEvent>>& /*events*/, const TInstant& /*until*/, TOfferPricing& /*result*/) const override;
    virtual void FillBill(TBill& /*bill*/, const TOfferPricing& /*pricing*/, TOfferStatePtr /*segmentState*/, ELocalization /*locale*/, const NDrive::IServer* /*server*/, ui32 /*cashbackPercent*/) const override;
    virtual TString GetTypeName() const override;
    virtual TString GetDefaultGroupName() const override;
    virtual double CalculateOriginalPrice(const TDuration /*stateDuration*/, const TString& /*tagName*/) const override;
    virtual TDuration GetFreeTime(const TDuration /*usedDuration*/, const TString& /*tagName*/) const override;
    virtual bool GetFreeAndPricedDurations(TDuration& /*freeDuration*/, TDuration& /*pricedDuration*/, const TMap<TString, TOfferSegment>& /*segments*/) const override;

    bool DeserializeFromProto(const NDrive::NProto::TOffer& /*info*/) override;
    NDrive::NProto::TOffer SerializeToProto() const override;
};
