#pragma once

#include "constants.h"

#include <drive/backend/billing/interfaces/entities.h>

#include <library/cpp/http/server/http.h>

class THttpServer;

struct TPaymentInfo {
    TPaymentInfo(ui64 sum, const TString& paymethodId)
        : Sum(sum)
        , PaymethodId(paymethodId)
    {}

    TString Token;
    ui64 Sum = 0;
    NDrive::NTrustClient::EPaymentStatus Status = NDrive::NTrustClient::EPaymentStatus::NotStarted;
    TString PaymethodId;

    TString GetReport() const {
        NJson::TJsonValue json;
        json["purchase_token"] = Token;
        json["payment_status"] = ToString(Status);
        json["payment_resp_code"] = (Status == NDrive::NTrustClient::EPaymentStatus::NotAuthorized) ? "not_enough_funds" : "";
        json["status"] = "success";
        json["payment_resp_desc"] = (Status == NDrive::NTrustClient::EPaymentStatus::NotAuthorized) ? "not_enough_funds" : "";
        json["paymethod_id"] = PaymethodId ? PaymethodId : "fake";
        json["currency"] = "RUB";
        json["uid"] = "fake";
        json["user_account"] = "";
        json["rrn"] = "";
        json["amount"] = ::ToString(Sum / 100.);
        json["cleared_amount"] = (Status == NDrive::NTrustClient::EPaymentStatus::Cleared) ? ::ToString(Sum / 100.) : "0";

        NJson::TJsonValue orderJson;
        orderJson["order_id"] = "123456";
        json["orders"].AppendValue(orderJson);
        return json.GetStringRobust();
    }
};

class TTrustEmulator : public THttpServer::ICallBack {
public:
    TTrustEmulator() = default;
    void Run(ui16 httpPort);
    virtual TClientRequest* CreateClient() override;
    ~TTrustEmulator();

    void RegisterPayment(const TPaymentInfo& info);
    TPaymentInfo CancelPayment(const TString& paymentId);
    TPaymentInfo StartPayment(const TString& paymentId);
    TPaymentInfo ClearPayment(const TString& paymentId);
    TPaymentInfo ProducePayment(const TString& paymentId);

    const TMap<TString, TPaymentInfo>& GetPayments() const {
        return Payments;
    }

private:
    THolder<THttpServer> Server;
    TMap<TString, TPaymentInfo> Payments;
};
