#include "charge_logic.h"

#include <drive/backend/billing/accounts/limited.h>


TString TWalletLogic::GetPaymentPrefix() const {
    return "w_";
}

TChargeInfo TWalletLogic::CorrectCharge(const NDrive::NBilling::IBillingAccount::TPtr account, const TPaymentsData& snapshot, const TChargeInfo& chargeInfo) const {
    if (snapshot.IsClosed()) {
        return TChargeInfo(chargeInfo.Type);
    }

    TChargeInfo parentChargeInfo = chargeInfo;
    if (account->GetParent()) {
        parentChargeInfo = CorrectCharge(account->GetParent(), snapshot, chargeInfo);
    }

    const NDrive::NBilling::TLimitedAccount* impl = account->GetAsSafe<NDrive::NBilling::TLimitedAccount>();
    if (impl->GetCurrentSpent() >= account->GetHardLimit()) {
        return TChargeInfo(parentChargeInfo.Type);
    }
    if (parentChargeInfo.Sum + impl->GetCurrentSpent() <= account->GetHardLimit()) {
        return parentChargeInfo;
    }
    TChargeInfo result(parentChargeInfo.Type);
    result.Sum = Min<ui32>(parentChargeInfo.Sum, account->GetHardLimit() - impl->GetCurrentSpent());
    return result;
}

bool TWalletLogic::DoRefund(NDrive::NBilling::IBillingAccount::TPtr account, const TPaymentTask& /*payment*/, ui32 sum, NDrive::TEntitySession& session, NStorage::TTableRecord& /*newPaymentRecord*/) const {
    if (account->GetType() != NDrive::NBilling::EAccount::Wallet) {
        return false;
    }
    return account->Add(sum, session) == EDriveOpResult::Ok;
}

void TWalletLogicConfig::Init(const TYandexConfig::Section* section, const TMap<TString, NSimpleMeta::TConfig>* /*requestPolicy*/) {
    Y_UNUSED(section);
}

void TWalletLogicConfig::ToString(IOutputStream& os) const {
    Y_UNUSED(os);
}

IChargeLogic::TPtr TWalletLogicConfig::ConstructLogic(const ISettings& settings, TUsersDB& /*users*/, TAtomicSharedPtr<NDrive::INotifier> /*notifier*/) const {
    return new TWalletLogic(settings);
}

ILogicConfig::TFactory::TRegistrator<TWalletLogicConfig> TWalletLogicConfig::Registrator(NDrive::NBilling::EAccount::Wallet);
