#pragma once

#include <drive/backend/billing/interfaces/logic.h>

class TWalletLogic : public IChargeLogic {
public:
    TWalletLogic(const ISettings& settings)
        : IChargeLogic(NDrive::NBilling::EAccount::Wallet, settings)
    {}
    virtual bool DoRefund(NDrive::NBilling::IBillingAccount::TPtr account, const TPaymentTask& payment, ui32 sum, NDrive::TEntitySession& session, NStorage::TTableRecord& /*newPaymentRecord*/) const override;
    TChargeInfo CorrectCharge(const NDrive::NBilling::IBillingAccount::TPtr account, const TPaymentsData& snapshot, const TChargeInfo& chargeInfo) const override;
    virtual TString GetPaymentPrefix() const override;
};

class TWalletLogicConfig : public ILogicConfig {
    static TFactory::TRegistrator<TWalletLogicConfig> Registrator;
public:
    virtual void Init(const TYandexConfig::Section* section, const TMap<TString, NSimpleMeta::TConfig>* /*requestPolicy*/) override;
    virtual void ToString(IOutputStream& os) const override;
    virtual IChargeLogic::TPtr ConstructLogic(const ISettings& settings, TUsersDB& /*users*/, TAtomicSharedPtr<NDrive::INotifier> /*notifier*/) const override;
    NDrive::NBilling::EAccount GetType() const override {
        return NDrive::NBilling::EAccount::Wallet;
    }
};
