#pragma once

#include "callback.h"

#include <drive/backend/billing/client/charge_logic.h>
#include <drive/backend/billing/client/client.h>
#include <drive/backend/billing/interfaces/logic.h>
#include <drive/backend/billing/interfaces/tasks.h>

#include <util/generic/queue.h>

class TYAccountLogicConfig : public ITrustLogicConfig {
    static TFactory::TRegistrator<TYAccountLogicConfig> Registrator;
public:
    virtual IChargeLogic::TPtr ConstructLogic(const ISettings& settings, TUsersDB& users, TAtomicSharedPtr<NDrive::INotifier> notifier) const override;
    NDrive::NBilling::EAccount GetType() const override {
        return NDrive::NBilling::EAccount::YAccount;
    }
};

class TYAccountLogic : public ITrustLogic {
public:
    TYAccountLogic(const TYAccountLogicConfig& trustConfig, const ISettings& settings, TUsersDB& usersDB, TAtomicSharedPtr<NDrive::INotifier> notifier);

    virtual TExpectedCharge ProducePayments(NDrive::NBilling::IBillingAccount::TPtr account, const TPaymentsData& snapshot, const TPaymentsManager& paymentsManager, const TChargeInfo& chargeInfo, TLazySession& session, const bool sync) const override;
    virtual TChargeInfo CorrectCharge(const NDrive::NBilling::IBillingAccount::TPtr /*account*/, const TPaymentsData& snapshot, const TChargeInfo& chargeInfo) const override;

    bool IsSync() const override {
        return true;
    }
};
