#include "callback.h"

#include "charge_logic.h"

#include <drive/backend/billing/client/callback.h>

#include <rtline/library/unistat/signals.h>

void TCreateCashbackAccountCallback::OnResult(const NJson::TJsonValue& json, bool isOk, ui16 /*code*/, const TBillingClient& trustClient) {
    if (isOk) {
        auto charge = Context.GetCharge();
        if (charge.Sum == 0) {
            return;
        }

        const TString paymethodId = json["payment_method_id"].GetString();
        if (!paymethodId) {
            auto session = Owner.BuildSession(false);
            if (Owner.UpdateTaskStatus(Payments.GetSessionId(), EPaymentStatus::IncorrectYAccount, session) == EDriveOpResult::Ok) {
                Y_UNUSED(session.Commit());
            }
            return;
        }

        auto product = trustClient.GetTrustProduct(charge.Type);
        if (!product.Defined()) {
            Notify("Incorrect terminal " + ToString(charge.Type));
            return;
        }

        NDrive::NTrustClient::TPayment payment = BuildPayment(Context, charge, product.GetRef(), paymethodId);
        Context.SetPayment(payment);
        TBillingClient::TOperation operation(ETrustOperatinType::TopupCreate, new TCreateTopupCallback(TrustLogic, Context, nullptr, Owner));
        operation.SetPayment(payment).SetPassportId(Context.GetPassportUid()).SetBillingType(charge.Type);
        TrustLogic.AddOperation(std::move(operation));
    } else {
        Notify(json.GetStringRobust());
    }
}

TCreateCashbackAccountCallback::TCreateCashbackAccountCallback(TYCashbackLogic& trustLogic, const TPaymentOpContext& context, const TCachedPayments& payments, const TPaymentsManager& manager)
    : TLogicCallback(trustLogic)
    , Payments(payments)
    , Context(context)
    , Owner(manager)
{
}

NDrive::NTrustClient::TPayment::TPayload ConstructPayload(const TChargeInfo& chargeInfo, const TVirtualTerminal& terminal) {
    NDrive::NTrustClient::TPayment::TPayload payload;
    payload.ServiceId = terminal.GetTrustServiceId();
    payload.BaseAmount = chargeInfo.BaseSum;
    payload.CashbackType = terminal.GetCashbackType();
    payload.IsPlusUser = chargeInfo.IsPlusUser;
    payload.OfferType = chargeInfo.OfferType;
    payload.OfferName = chargeInfo.OfferName;
    payload.OrderId = chargeInfo.SessionId;
    payload.PayloadType = chargeInfo.PayloadType;
    payload.PayloadExtra = chargeInfo.PayloadExtra;
    return payload;
}

NDrive::NTrustClient::TPayment TCreateCashbackAccountCallback::BuildPayment(const TPaymentOpContext& /*context*/, const TChargeInfo& charge, const TVirtualTerminal& product, const TString& paymethodId) {
    NDrive::NTrustClient::TPayment payment;
    payment.Amount = charge.Sum;
    payment.ProductId = product.GetTrustProduct();
    payment.Currency = "RUB";
    payment.PaymethodId = paymethodId;
    payment.Payload = ConstructPayload(charge, product);
    return payment;
}
