#pragma once

#include <drive/backend/billing/client/callback.h>

#include <drive/backend/abstract/notifier.h>

class TYCashbackLogic;

class TCreateCashbackAccountCallback: public TLogicCallback {
public:
    TCreateCashbackAccountCallback(TYCashbackLogic& YCashbackLogic,
                           const TPaymentOpContext& context,
                           const TCachedPayments& payments,
                           const TPaymentsManager& manager);
    static NDrive::NTrustClient::TPayment BuildPayment(const TPaymentOpContext& context, const TChargeInfo& charge, const TVirtualTerminal& product, const TString& card);
protected:
    virtual void OnResult(const NJson::TJsonValue& json, bool isOk, ui16 /*code*/, const TBillingClient& client) override;
    virtual TString GetOperation() const override {
        return "create_cashback_account";
    }

private:
    TCachedPayments Payments;
    TPaymentOpContext Context;
    const TPaymentsManager& Owner;
};

class TCreateTopupCallback: public TCreatePaymentCallback<TLogicCallback> {
public:
    TCreateTopupCallback(ITrustLogic& trustLogic, const TPaymentOpContext& context, NDrive::NBilling::IBillingAccount::TPtr account, const TPaymentsManager& manager)
        : TCreatePaymentCallback<TLogicCallback>(trustLogic, context, account, manager)
    {}

protected:
    virtual NDrive::NBilling::EAccount GetPaymentType() const override {
        return NDrive::NBilling::EAccount::YCashback;
    }

    virtual ETrustOperatinType GetStartOperation() const override {
        return ETrustOperatinType::TopupStart;
    }
    virtual TString GetOperation() const override {
        return "create_topup";
    }
};
