#pragma once

#include "callback.h"

#include <drive/backend/billing/client/charge_logic.h>
#include <drive/backend/billing/client/client.h>
#include <drive/backend/billing/interfaces/logic.h>
#include <drive/backend/billing/interfaces/tasks.h>

#include <util/generic/queue.h>

class TYCashbackLogicConfig : public ITrustLogicConfig {
    static TFactory::TRegistrator<TYCashbackLogicConfig> Registrator;
public:
    virtual IChargeLogic::TPtr ConstructLogic(const ISettings& settings, TUsersDB& users, TAtomicSharedPtr<NDrive::INotifier> notifier) const override;
    NDrive::NBilling::EAccount GetType() const override {
        return NDrive::NBilling::EAccount::YCashback;
    }
};

class TYCashbackLogic : public ITrustLogic {
public:
    TYCashbackLogic(const TYCashbackLogicConfig& trustConfig, const ISettings& settings, TUsersDB& usersDB, TAtomicSharedPtr<NDrive::INotifier> notifier);

    virtual EProduceResult SyncPayments(const TPaymentsData& snapshot, const TPaymentsManager& manager, const NDrive::NBilling::TAccountsManager& accountsManager, ITrustStorage* cache, const bool sync) const override;
    virtual TExpectedCharge ProducePayments(NDrive::NBilling::IBillingAccount::TPtr /*account*/, const TPaymentsData& snapshot, const TPaymentsManager& paymentsManager, const TChargeInfo& chargeInfo, TLazySession& session, const bool /*sync*/) const override;
    virtual TChargeInfo CorrectCharge(const NDrive::NBilling::IBillingAccount::TPtr /*account*/, const TPaymentsData& snapshot, const TChargeInfo& chargeInfo) const override;

    bool IsSync() const override {
        return false;
    }
};
