#include "attachment.h"

#include <rtline/util/json_processing.h>

void IJsonBlobSerializableCarAttachment::ParseDateIntoField(const NJson::TJsonValue& payload, const TString& fieldName, TInstant& resultField) {
    TString dateStr;
    if (payload.Has(fieldName) && payload[fieldName].IsString()) {
        dateStr = payload[fieldName].GetString();
    }
    if (dateStr.size() < 10) {
        return;
    }
    resultField = TInstant::TryParseIso8601(dateStr.substr(0, 10), resultField) ? resultField : TInstant::Zero();
}

bool IJsonBlobSerializableCarAttachment::UpdateDateField(TInstant& field, const TString& value) {
    TInstant newDate = TInstant::Zero();

    double excelFormatDatestamp;
    if (value.size() > 0 && TryFromString(value, excelFormatDatestamp)) {
        /*
            Excel format for dates: number of days since 1900-01-01.
        */
        newDate = TInstant::Seconds(((ui64)(excelFormatDatestamp + 0.1) - 25569) * 86400);
    } else if (value.size() > 0 && !TInstant::TryParseIso8601(value, newDate)) {
        return false;
    }
    if (field == newDate) {
        return false;
    }
    field = newDate;
    return true;
}

ISimpleAttachment::ISimpleAttachment(const TString& code) :
    Code(code)
{
}

NJson::TJsonValue ISimpleAttachment::BuildReport(const ICarAttachmentReportContext& /*context*/) const {
    NJson::TJsonValue result;
    result["code"] = Code;
    return result;
}

bool ISimpleAttachment::DeserializeFromJsonBlob(const NJson::TJsonValue& blob) {
    JREAD_STRING(blob, "code", Code);
    Code = ToUpperUTF8(Code);
    return true;
}

TString ISimpleAttachment::GetServiceAppSlug() const {
    return Code;
}
