#pragma once

#include <drive/backend/car_attachments/abstract/attachment.h>

class TFuelCard : public IJsonBlobSerializableCarAttachment {
    R_READONLY(TString, Code);
    R_READONLY(TString, Pin);
    R_READONLY(TString, Station);
    static TFactory::TRegistrator<TFuelCard> Registrator;

public:
    struct TCardFields {
        TString Code;
        TString Pin;
        TString Station;
    };

    TFuelCard() = default;
    TFuelCard(const TString& code, const TString& pin = "", const TString& station = "");
    virtual NJson::TJsonValue BuildReport(const ICarAttachmentReportContext& context) const override;
    virtual bool DeserializeFromJsonBlob(const NJson::TJsonValue& blob) override;
    virtual EUniquePolicy GetUniquePolicy() const override;
    virtual EDocumentAttachmentType GetTypeName() const override;
    static TVector<THolder<TFuelCard>> ConstructFromAdmin(const NJson::TJsonValue& rawData, const TVector<TCardFields>& customFields);
};
