#pragma once

#include <drive/backend/car_attachments/abstract/attachment.h>

namespace NDrive {
    enum class EInsuranceProvider {
        Fake /* "fake" */,
        Renins /* "renins" */,
        Ingos /* "ingos" */
    };
}

class TCarInsurancePolicy : public IJsonBlobSerializableCarAttachment {
    R_READONLY(TString, AgreementPartnerNumber);
    R_READONLY(TString, AgreementNumber);
    R_READONLY(NDrive::EInsuranceProvider, Provider, NDrive::EInsuranceProvider::Fake);
    R_READONLY(ui32, BaseCost, 0);
    R_READONLY(ui32, PerMinuteCost, 0);

    R_READONLY(TInstant, ValidFrom);
    R_READONLY(TInstant, ValidUntil);

    static TFactory::TRegistrator<TCarInsurancePolicy> Registrator;
public:
    TCarInsurancePolicy() = default;
    TCarInsurancePolicy(const TString& agreementPartnerNumber, const TString& agreementNumber, ui32 baseCost, ui32 perMinuteCost, const TInstant validFrom = TInstant::Zero(), const TInstant validUntil = TInstant::Zero());
    virtual NJson::TJsonValue BuildReport(const ICarAttachmentReportContext& context) const override;
    bool DeserializeFromJsonBlob(const NJson::TJsonValue& blob) override;

    bool ConstructFromAdmin(const NJson::TJsonValue& rawData, const NDrive::EInsuranceProvider provider, const ui32 baseCost);

    EDocumentAttachmentType GetTypeName() const override {
        return EDocumentAttachmentType::CarInsurancePolicy;
    }

    TString GetAbsenceTagName() const override {
        return "need_insurance";
    }

    EUniquePolicy GetUniquePolicy() const override {
        return EUniquePolicy::NotUnique;
    }
};
