#pragma once

#include <drive/backend/car_attachments/abstract/attachment.h>

class TYTaxiAirportPass : public ISimpleAttachment {
    using ISimpleAttachment::ISimpleAttachment;

    static TFactory::TRegistrator<TYTaxiAirportPass> Registrator;
public:
    EDocumentAttachmentType GetTypeName() const override {
        return EDocumentAttachmentType::CarAirportPass;
    }

    EUniquePolicy GetUniquePolicy() const override {
        return EUniquePolicy::Unique;
    }
};

class TTransponder : public ISimpleAttachment {
    using ISimpleAttachment::ISimpleAttachment;

    static TFactory::TRegistrator<TTransponder> Registrator;
public:
    EDocumentAttachmentType GetTypeName() const override {
        return EDocumentAttachmentType::CarTransponder;
    }

    EUniquePolicy GetUniquePolicy() const override {
        return EUniquePolicy::Unique;
    }
};

class TTransponderSpb : public ISimpleAttachment {
    using ISimpleAttachment::ISimpleAttachment;

    static TFactory::TRegistrator<TTransponderSpb> Registrator;
public:
    EDocumentAttachmentType GetTypeName() const override {
        return EDocumentAttachmentType::CarTransponderSpb;
    }

    EUniquePolicy GetUniquePolicy() const override {
        return EUniquePolicy::Unique;
    }

    virtual TString GetPresenceTagName() const override {
        return "transponder";
    }
};

class TCarQrCode : public ISimpleAttachment {
public:
    using ISimpleAttachment::ISimpleAttachment;

    EDocumentAttachmentType GetTypeName() const override {
        return EDocumentAttachmentType::CarQrCode;
    }

    EUniquePolicy GetUniquePolicy() const override {
        return EUniquePolicy::NotUnique;
    }

private:
    static TFactory::TRegistrator<TCarQrCode> Registrator;
};

class TAirportPassSpb : public ISimpleAttachment {
    using ISimpleAttachment::ISimpleAttachment;

    static TFactory::TRegistrator<TAirportPassSpb> Registrator;
public:
    EDocumentAttachmentType GetTypeName() const override {
        return EDocumentAttachmentType::CarAirportPassSpb;
    }

    EUniquePolicy GetUniquePolicy() const override {
        return EUniquePolicy::Unique;
    }
};
