#pragma once

#include <drive/backend/car_attachments/abstract/attachment.h>

#include <drive/library/cpp/mds/client.h>

class TModelsDB;

namespace NDrive {
    class IServer;
}

class TCarRegistryDocument : public IJsonBlobSerializableCarAttachment {
public:
    enum class EFields {
        Vin /* "vin" */,
        Manufacturer /* "manufacturer" */,
        Model /* "model" */,
        Number /* "number" */,
        RegistrationId /* "registration_id" */,
        RegistrationDate /* "registration_date" */,
        RegistrationMDSKey /* "registration_mds_key" */,
        RegistrationMDSHRKey /* "registration_mds_hr_key" */,
        ProductionYear /* "production_year" */,
        IMEI /* "imei" */,
        FuelCardNumber /* "fuel_card_number" */,
        AntitheftSystem /* "antitheft_system" */,
        NumberOfKeys /* "number_of_keys" */,
        Color /* "color" */,
        ContractId /* "contract_id" */,
        ContractDate /* "contract_date" */,
        Dealer /* "dealer" */,
        Lessor /* "lessor" */,
        RecontractingDate /* "recontracting_date" */,
        TransferDate /* "transfer_date" */,
        DagoCost /* "dago_cost" */,
        DagoDate /* "dago_date" */,
        DagoDateTo /* "dago_date_to" */,
        OsagoCost /* "osago_cost" */,
        OsagoNumber /* "osago_number" */,
        OsagoMDSKey /* "osago_mds_key" */,
        OsagoMDSHRKey /* "osago_mds_hr_key" */,
        OsagoDate /* "osago_date" */,
        OsagoDateTo /* "osago_date_to" */,
        MarkByPts /* "mark_by_pts" */,
        PtsNumber /* "pts_number" */,
        DeptransDocumentsDate /* "deptrans_documents_date" */,
        ParkingPermitCost /* "parking_permit_cost" */,
        ParkingPermitStartDate /* "parking_permit_start_date" */,
        ParkingPermitExpirationDate /* "parking_permit_expiration_date" */,
        CascoNumber /* "casco_number" */,
        DkpPrice /* "dkp_price" */,
        DsPayment /* "ds_payment" */,
        RecontractingDsPayment /* "recontracting_ds_payment" */,
        RecontractingContractMileage /* "recontracting_contract_mileage" */,
        RecontractingContractMileageDate /* "recontracting_contract_mileage_date" */,
        RecontractingLeaseTermMonths /* "recontracting_lease_term_months" */,
        RecontractingLeaseTermMonthsDate /* "recontracting_lease_term_months_date" */,
        RecontractingUnderOverrunRate /* "recontracting_under_over_run_rate" */,
        RecontractingUnderOverrunRateDate /* "recontracting_under_over_run_rate_date" */,
        LeaseTermMonths /* "lease_term_months" */,
        LeasingEndDate /* "leasing_end_date" */,
        ReturnDate /* "return_date" */,
        PretermReturnDate /* "preterm_return_date" */,
        EstimatedReturnDate /* "estimated_return_date" */,
        ContractMileage /* "contract_mileage" */,
        MajorAppMDSKey /* "major_app_mds_key" */,
        MajorAppMDSHRKey /* "major_app_mds_hr_key" */,
        LeaseFirstPaymentDate /* "lease_first_payment_date" */,
        FrameworkAgreementNumber /* "framework_agreement_number" */,
        FrameworkAgreementDate /* "framework_agreement_date" */,
        FrameworkAgreementFileName /* "framework_agreement_filename" */,
        TotalInsuranceAckDate /* "total_insurance_ack_date" */,
        TotalInsuranceEligible /* "total_insurance_eligible" */,
        TotalIneligibleDate /* "total_ineligible_date" */,
        TotalIneligiblePartyAtFault /* "total_ineligible_party_at_fault" */,
        TotalIneligibleStatus /* "total_ineligible_status" */,
        TotalIneligibleTicketLink /* "total_ineligible_ticket_link" */,
        VegaVersion /* "vega_version" */,
        SendingCarTransporterDate /* "sending_car_transporter_date" */,
        SendingCarTransporterPrice /* "sending_car_transporter_price" */,
        Id /* "id" */,
        OverRunRate /* "over_run_rate" */,
        UnderRunRate /* "under_run_rate" */,
        UnderOverRunRate /* "under_over_run_rate" */,
        AvailableForLongTermUntil /* "available_for_long_term_until" */,
        PurchaseContractNumber /* "dkp_id" */,
        PurchaseContractDate /* "dkp_date" */,
        PurchaseContractFileName /* "dkp_filename" */,
        PurchaseContractDirName /* "dkp_dirname" */,
        ContractIdDate /* "contract_id_date" */,
        City /* "city" */,
    };

private:
    static TFactory::TRegistrator<TCarRegistryDocument> Registrator;

private:
    R_FIELD(TString, Vin);
    R_READONLY(TString, ContractId);
    R_READONLY(TInstant, ContractDate, TInstant::Zero());
    R_READONLY(TInstant, RecontractingDate);
    R_READONLY(TString, Lessor);
    R_READONLY(TString, Manufacturer);
    R_READONLY(TString, Model);
    R_FIELD(TString, Number);
    R_FIELD(TString, Dealer);
    R_FIELD(ui64, RegistrationId, 0);
    R_FIELD(TInstant, RegistrationDate, TInstant::Zero());
    R_FIELD(TString, RegistrationMDSKey);
    R_READONLY(TInstant, TransferDate, TInstant::Zero());
    R_READONLY(float, DagoCost, -1.0);
    R_READONLY(TInstant, DagoDate, TInstant::Zero());
    R_READONLY(TInstant, DagoDateTo, TInstant::Zero());
    R_READONLY(float, OsagoCost, -1.0);
    R_FIELD(TString, OsagoNumber);
    R_FIELD(TInstant, OsagoDate, TInstant::Zero());
    R_FIELD(TInstant, OsagoDateTo, TInstant::Zero());
    R_FIELD(TString, OsagoMDSKey);
    R_READONLY(TString, MarkByPts);
    R_READONLY(TString, ProductionYear);
    R_READONLY(TString, PtsNumber);
    R_READONLY(TString, AntitheftSystem);
    R_READONLY(TString, NumberOfKeys);
    R_READONLY(TInstant, DeptransDocumentsDate, TInstant::Zero());
    R_READONLY(float, ParkingPermitCost, -1.0);
    R_READONLY(TInstant, ParkingPermitStartDate, TInstant::Zero());
    R_READONLY(TInstant, ParkingPermitExpirationDate, TInstant::Zero());
    R_READONLY(TInstant, LeaseFirstPaymentDate, TInstant::Zero());
    R_READONLY(TInstant, TotalInsuranceAckDate, TInstant::Zero());
    R_READONLY(bool, TotalInsuranceEligible, true);
    R_READONLY(TInstant, TotalIneligibleDate, TInstant::Zero());
    R_READONLY(TString, TotalIneligiblePartyAtFault);
    R_READONLY(TString, TotalIneligibleStatus);
    R_READONLY(TString, TotalIneligibleTicketLink);
    R_READONLY(TString, IMEI);
    R_READONLY(TString, FuelCardNumber);
    R_READONLY(TString, CascoNumber);
    R_READONLY(float, DkpPrice, -1.0);
    R_READONLY(TString, Color);
    R_READONLY(float, DsPayment, -1.0);
    R_READONLY(float, RecontractingDsPayment, -1.0);
    R_READONLY(float, RecontractingContractMileage, -1.0);
    R_READONLY(TInstant, RecontractingContractMileageDate, TInstant::Zero());
    R_READONLY(ui32, RecontractingLeaseTermMonths, 0);
    R_READONLY(TInstant, RecontractingLeaseTermMonthsDate, TInstant::Zero());
    R_READONLY(float, RecontractingUnderOverrunRate, 0.0);
    R_READONLY(TInstant, RecontractingUnderOverrunRateDate, TInstant::Zero());
    R_READONLY(ui32, LeaseTermMonths, 0);
    R_READONLY(TInstant, LeasingEndDate, TInstant::Zero());
    R_READONLY(TInstant, ReturnDate, TInstant::Zero());
    R_READONLY(TInstant, PretermReturnDate, TInstant::Zero());
    R_READONLY(TInstant, EstimatedReturnDate, TInstant::Zero());
    R_READONLY(float, ContractMileage, -1.0);
    R_FIELD(TString, MajorAppMDSKey);
    R_READONLY(TInstant, SendingCarTransporterDate, TInstant::Zero());
    R_READONLY(float, SendingCarTransporterPrice, -1.0);
    R_READONLY(float, OverRunRate, 0.0);
    R_READONLY(float, UnderRunRate, 0.0);
    R_READONLY(float, UnderOverRunRate, 0.0);
    R_READONLY(TInstant, AvailableForLongTermUntil, TInstant::Zero());
    R_READONLY(TString, PurchaseContractNumber);
    R_READONLY(TInstant, PurchaseContractDate, TInstant::Zero());
    R_READONLY(TInstant, ContractIdDate, TInstant::Zero());
    R_READONLY(TString, City);

public:
    TCarRegistryDocument() = default;

    virtual bool DeserializeFromJsonBlob(const NJson::TJsonValue& regDocument) override;
    virtual NJson::TJsonValue BuildReport(const ICarAttachmentReportContext& context) const override;
    bool PatchWithRawRegistryData(const NJson::TJsonValue& registryData);
    bool PatchWithCarJSON(const NJson::TJsonValue& payload, const TModelsDB* modelsData, const TInstant actuality = TInstant::Zero());
    bool UpdateOSAGO(bool& isUpdate, const TS3Client::TBucket& mdsBucket, const NDrive::IServer& server, TMessagesCollector& error, const bool isCurrent = false);

    virtual TString GetAbsenceTagName() const override {
        return "need_number";
    }

    EUniquePolicy GetUniquePolicy() const override {
        return EUniquePolicy::Unique;
    }

    EDocumentAttachmentType GetTypeName() const override {
        return EDocumentAttachmentType::CarRegistryDocument;
    }
};
