#pragma once

#include <util/system/types.h>
#include <util/generic/ylimits.h>

namespace NDeviceReport {
    using TReportTraits = ui64;
    static const TReportTraits NoTraits = 0;
    enum EReportTraits: ui64 {
      //ReportUnused = 1 << 0,
        ReportIMEI = 1 << 1,
        ReportLocationDetails = 1 << 2,
        ReportSelected = 1 << 3,
        ReportVIN = 1 << 4,
        ReportTags = 1 << 5,
        ReportStatus = 1 << 6,
        ReportAttachments = 1 << 7,
        ReportCarId = 1 << 8,
        ReportTagDetails = 1 << 9,
        ReportCars = 1 << 10,
        ReportLocationCourse = 1 << 11,
        ReportModels = 1 << 12,
        ReportLag = 1 << 13,
        ReportSensorTimestamp = 1 << 14,
        ReportFilters = 1 << 15,
        ReportRegistrationId = 1 << 16,
        ReportIncorrectLocation = 1 << 17,
        ReportSurgeInfo = 1 << 18,
        ReportAvailability = 1 << 19,
        ReportUpdateTimestamp = 1 << 20,
        DeepLink = 1 << 21,
        ReportPatches = 1 << 22,
        ReportShortProps = 1 << 23,
        ReportCurrentOffer = 1 << 24,
        ReportUserRectOnly = 1 << 25,
        ReportShowAllModels = 1 << 26,
        ReportGeocodedLocation = 1 << 27,
        ReportVisibility = 1 << 28,
        ReportInsuranceAgreementNumber = 1 << 29,
        ReportClusters = 1 << 30,
        ReportFutures = 1ll << 31,
        ReportFuturesArea = 1ll << 32,
        ReportHiddenDiscounts = 1ll << 33,
        ReportRTFuturesPosition = 1ll << 34,
        ReportHeadId = 1ll << 35,
        ReportViews = 1ll << 36,
        ReportFormerNumbers = 1ll << 37,
        ReportBluetoothInfo = 1ll << 38,
        ReportTagsArray = 1ll << 39,
        ReportColors = 1ll << 40,
        ReportBeaconParkingPlace = 1ll << 41,
        ReportEnclosingAreas = 1ll << 42,
        ReportBluetoothMAC = 1ll << 43,
        ReportLeasingStats = 1ll << 44,
        ReportTaxiCompany = 1ll << 45,
        ReportValidatedPhotos = 1ll << 46,
        ReportSupportFilterPhotos = 1ll << 47,
        ReportOrganizationOnly = 1ll << 48,
        ReportValidatedPhotosMarkup = 1ll << 49,
        ReportValidatedPhotosDups = 1ll << 50,
        ReportValidatedPhotosElementDups = 1ll << 51,
        ReportCurrentOfferDetails = 1ll << 52,
        ReportAggressiveScore = 1ll << 53,
        ReportDocuments = 1ll << 54,
        ReportServiceSessions = 1ll << 55,
        ReportCommonSpeed = 1ll << 56,
        ReportSignalq = 1ll << 57,
    };

    static constexpr TReportTraits ReportAll =
        Max<TReportTraits>()
        - EReportTraits::ReportSurgeInfo
        - EReportTraits::DeepLink
        - EReportTraits::ReportSupportFilterPhotos
        - EReportTraits::ReportOrganizationOnly;

    static constexpr TReportTraits ReportServiceApp =
        EReportTraits::ReportModels
        | EReportTraits::ReportStatus
        | EReportTraits::ReportColors
        | EReportTraits::ReportCarId
        | EReportTraits::ReportCars
        | EReportTraits::ReportIncorrectLocation
        | EReportTraits::ReportUserRectOnly
        | EReportTraits::ReportVisibility
        | EReportTraits::ReportVIN
        | EReportTraits::ReportViews
        | EReportTraits::ReportSurgeInfo
        | EReportTraits::ReportEnclosingAreas
        | EReportTraits::ReportBluetoothMAC;

    static constexpr TReportTraits ReportExternal =
        EReportTraits::ReportCars
        | EReportTraits::ReportModels
        | EReportTraits::DeepLink
        | EReportTraits::ReportPatches
        | EReportTraits::ReportViews;

    static constexpr TReportTraits ReportAvailableModels =
        EReportTraits::ReportModels;

    static constexpr TReportTraits ReportServiceAppDetails =
        ReportAll
        - EReportTraits::ReportValidatedPhotos
        - EReportTraits::ReportLocationCourse
        - EReportTraits::ReportShortProps
        - EReportTraits::ReportFormerNumbers
        + EReportTraits::ReportSurgeInfo;

    static constexpr TReportTraits ReportServiceAppStat =
        EReportTraits::ReportTags
        | EReportTraits::ReportTagsArray
        | EReportTraits::ReportModels
        | EReportTraits::ReportUserRectOnly
        | EReportTraits::ReportStatus
        | EReportTraits::ReportSurgeInfo;

    static constexpr TReportTraits ReportUserApp =
        EReportTraits::ReportLocationCourse
        | EReportTraits::ReportClusters
        | EReportTraits::ReportCars
        | EReportTraits::ReportModels
        | EReportTraits::ReportFilters
        | EReportTraits::ReportPatches
        | EReportTraits::ReportViews
        | EReportTraits::ReportShortProps
        | EReportTraits::ReportVisibility
        | EReportTraits::ReportFutures
        | EReportTraits::ReportHiddenDiscounts
        | EReportTraits::ReportBeaconParkingPlace;

    static constexpr TReportTraits ReportAdminIFace =
        EReportTraits::ReportStatus
        | EReportTraits::ReportCarId
        | EReportTraits::ReportCurrentOffer
        | EReportTraits::ReportCars
        | EReportTraits::ReportModels
        | EReportTraits::ReportTags
        | EReportTraits::ReportTagsArray
        | EReportTraits::ReportSurgeInfo
        | EReportTraits::ReportIncorrectLocation
        | EReportTraits::ReportFutures
        | EReportTraits::ReportFuturesArea
        | EReportTraits::ReportHiddenDiscounts
        | EReportTraits::ReportRTFuturesPosition;

    static constexpr TReportTraits ReportSession =
        EReportTraits::ReportCarId
        | EReportTraits::ReportLocationCourse
        | EReportTraits::ReportModels
        | EReportTraits::ReportPatches
        | EReportTraits::ReportViews
        | EReportTraits::ReportIncorrectLocation
        | EReportTraits::ReportShortProps
        | EReportTraits::ReportValidatedPhotos
        | EReportTraits::ReportSupportFilterPhotos
        | EReportTraits::ReportValidatedPhotosMarkup
        | EReportTraits::ReportValidatedPhotosDups
        | EReportTraits::ReportValidatedPhotosElementDups
        | EReportTraits::ReportGeocodedLocation
        | EReportTraits::ReportFutures
        | EReportTraits::ReportFuturesArea
        | EReportTraits::ReportBluetoothInfo
        | EReportTraits::ReportIMEI;

    static constexpr TReportTraits ReportHistory =
        EReportTraits::ReportIMEI
        | EReportTraits::ReportVIN
        | EReportTraits::ReportCarId
        | EReportTraits::ReportCars
        | EReportTraits::ReportPatches
        | EReportTraits::ReportViews
        | EReportTraits::ReportModels
        | EReportTraits::ReportRegistrationId
        | EReportTraits::ReportShortProps;

    static constexpr TReportTraits ReportOffers =
        ReportUserApp
        | EReportTraits::ReportGeocodedLocation
        | EReportTraits::ReportFuturesArea
        | EReportTraits::ReportBeaconParkingPlace;

    static constexpr TReportTraits ReportAdminHistory =
        ReportHistory
        | EReportTraits::ReportInsuranceAgreementNumber
        | EReportTraits::ReportFormerNumbers;

    static constexpr TReportTraits ReportLeasing =
        EReportTraits::ReportModels
        | EReportTraits::ReportStatus
        | EReportTraits::ReportCarId
        | EReportTraits::ReportCars
        | EReportTraits::ReportViews
        | EReportTraits::ReportLeasingStats
        | EReportTraits::ReportIncorrectLocation
        | EReportTraits::ReportTaxiCompany
        | EReportTraits::ReportLocationCourse
        | EReportTraits::ReportGeocodedLocation;

    static constexpr TReportTraits ReportDedicatedFleet =
        EReportTraits::ReportModels
        | EReportTraits::ReportStatus
        | EReportTraits::ReportCarId
        | EReportTraits::ReportCars
        | EReportTraits::ReportCurrentOffer
        | EReportTraits::ReportOrganizationOnly
        | EReportTraits::ReportClusters
        | EReportTraits::ReportPatches
        | EReportTraits::ReportShortProps
        | EReportTraits::ReportViews
        | EReportTraits::ReportLocationCourse;

    static constexpr TReportTraits ReportTaxiParks =
        EReportTraits::ReportCars
        | EReportTraits::ReportTags
        | EReportTraits::ReportTagDetails
        | EReportTraits::ReportVIN
        | EReportTraits::ReportIncorrectLocation;
}
