#pragma once

#include "messages_history_manager.h"

#include <drive/backend/database/history/sequential.h>

#include <drive/library/cpp/threading/concurrent_cache.h>

#include <rtline/library/unistat/signals.h>
#include <rtline/util/auto_actualization.h>
#include <rtline/util/types/expected.h>

namespace NDrive::NChat {
    using TExpectedMessageEvents = TExpected<TMessageEvents, TCodedException>;

    class TMessagesCache: public IAutoActualization {
    public:
        class TCachedMessageEvents {
        private:
            R_FIELD(TMessageEvents, Events);
            R_FIELD(TInstant, Timestamp);

        public:
            TCachedMessageEvents() = default;
            TCachedMessageEvents(const TMessageEvents& events, const TInstant timestamp)
                : Events(events)
                , Timestamp(timestamp)
            {
            }
        };

    public:
        TMessagesCache(const TString& tableName, TDuration defaultLifetime, const TChatMessagesHistoryManager& messagesHistoryManager, const TChatsMetaManager& chats);

        bool UpdateCachedMessages(const TSet<TString>& searchIds, NDrive::TEntitySession& session, const TInstant& requestTime) const;
        TExpectedMessageEvents GetCachedMessages(const TString& searchId) const;

        bool Invalidate(const TString& searchId) const;

        bool RefreshCache() {
            return Refresh();
        }

    protected:
        bool GetStartFailIsProblem() const override;
        bool Refresh() override;

    private:
        TMessageEvents GetCachedObjectImpl(const TString& searchId, bool& expired, bool& cached) const;
        TMaybe<TDuration> GetLifetime() const;

        const TChatMessagesHistoryManager& MessagesHistoryManager;
        const TChatsMetaManager& Chats;
        const TDuration DefaultLifetime;

        TUnistatSignal<double> CacheHit;
        TUnistatSignal<double> CacheMiss;
        TUnistatSignal<double> CacheExpired;
        TUnistatSignal<double> CacheInvalidated;
        IBaseSequentialTableImpl::TOptionalEventId LastEventId;

        mutable NUtil::TConcurrentCache<TString, TCachedMessageEvents> ObjectCache;
    };
}
