#pragma once

#include "message.h"
#include "chats.h"

#include <drive/backend/database/entity/manager.h>
#include <drive/backend/database/history/manager.h>

namespace NDrive::NChat {
    class TChatMessagesHistoryManager: public TDatabaseHistoryManager<TMessage> {
    public:
        using TIdRef = typename TIdTypeSelector<typename TChat::TId>::TIdRef;

        class TMessagesRequestContext {
            R_OPTIONAL(ui32, ChatId);
            R_OPTIONAL(TSet<TMessage::EMessageType>, IncludedTypes);

        public:
            TMessagesRequestContext() = default;
            TMessagesRequestContext(const ui32 chatId)
                : ChatId(chatId)
            {
            }

            TQueryOptions GenerateQueryOptions() const;
        };

    private:
        using TBase = TDatabaseHistoryManager<TMessage>;
        using TEvent = TObjectEvent<TMessage>;
        using TEventPtr = TAtomicSharedPtr<TObjectEvent<TMessage>>;

    private:
        static ui64 GetMessageId(const NDrive::NChat::TChatMessagesHistoryManager::TEventPtr& event);

    private:
        void InsertSorted(TMessageEvents& chatMessages, TMessageEvent& message, const ui32 viewerTraits) const;
        TMessageEvents SortAndFilterMessages(TMessageEvents& events, const ui32 viewerTraits, const TMaybe<ui64> startId = {}, const TMaybe<ui64> finishId = {}, const TMaybe<i64> count = {}) const;

    public:
        TChatMessagesHistoryManager(const IHistoryContext& context, const THistoryConfig& /*hConfig*/)
            : TBase(context, "messages_history")
        {
        }

        static ui64 GetMessageId(const NDrive::NChat::TMessageEvent& event);

        TOptionalMessageEvents GetMessagesFromDb(const TMessagesRequestContext& requestContext, const TRange<ui64>& idRange, const TRange<TInstant>& timestampRange, const ui32 viewerTraits, NDrive::TEntitySession& session) const;

        TMaybe<TObjectEventPtr<TMessage>> GetMessage(const ui64 messageId, NDrive::TEntitySession& session) const;
        bool GetLastMessage(const ui32 chat, const ui32 viewerTraits, NDrive::TEntitySession& session, TMaybe<NDrive::NChat::TMessageEvent>& result, const TString& userId = "") const;

        TMaybe<size_t> GetMessagesCountSince(const ui32 chat, const ui32 viewerTraits, const ui64 sinceId, NDrive::TEntitySession& session, const TSet<TMessage::EMessageType>& excludeTypes = {}, const TMaybe<TSet<TMessage::EMessageType>>& includeTypes = {}) const;
        TMaybe<TChatMessages> GetMessagesByChats(const TVector<TChat>& chats, const TRange<ui64>& idRange, const TRange<TInstant>& timestampRange, const ui32 viewerTraits, NDrive::TEntitySession& session) const;
        TMaybe<TChatMessages> GetMessagesByChats(const TMap<ui64, TString>& searchIdsByChatIds, const TRange<ui64>& idRange, const TRange<TInstant>& timestampRange, const ui32 viewerTraits, NDrive::TEntitySession& session) const;
    };
}
