#include "bot.h"

NThreading::TFuture<void> TChannelChatBot::AcceptUserResponse(const IChatUserContext::TPtr context, const TMessage& message, const TVector<TMessageAttachment>& attachments, const TString& /*operatorId*/) const {
    if (attachments.size()) {
        return NThreading::TExceptionFuture() << "non empty attachments in channel";
    }
    TMessage actualMessage = message;
    auto session = BuildChatEngineSession();
    if (!SendArbitraryMessage(context->GetUserId(), context->GetChatTopic(), "robot-frontend", actualMessage, session) || !session.Commit()) {
        return NThreading::TExceptionFuture() << "cannot add message " << session.GetStringReport();
    }
    return NThreading::MakeFuture();
}

bool TChannelChatBot::RegisterMediaResource(const TString& /*userId*/, const TString& /*resourceId*/, const TString& /*contentType*/, const bool /*shared*/, NDrive::TEntitySession& /*session*/) const {
    ythrow yexception() << "RegisterMediaResource not implemented";
}

void TChannelChatBot::AcceptMediaResource(const IChatUserContext::TPtr /*context*/, const TString& /*resourceId*/, const TString& /*contentType*/, const TString& /*content*/, TAtomicSharedPtr<IChatMediaResourcePostUploadCallback> /*callback*/) const {
    ythrow yexception() << "AcceptMediaResource not implemented";
}

NThreading::TFuture<TChatResourceAcquisitionResult> TChannelChatBot::GetMediaResource(const IChatUserContext::TPtr /*context*/, const TString& /*resourceId*/, const bool /*needsFurtherProcessing*/) const {
    ythrow yexception() << "GetMediaResource not implemented";
}

bool TChannelChatBot::UpdateMediaResourceDescription(const TMediaResourceDescription /*description*/, const TString& /*actorUserId*/, NDrive::TEntitySession& /*session*/) const {
    ythrow yexception() << "UpdateMediaResourceDescription not implemented";
}

NThreading::TFuture<void> TChannelChatBot::UploadResourcePreview(const TString& /*content*/, const TMediaResourceDescription& /*description*/, const TString& /*contentType*/) const {
    ythrow yexception() << "UploadResourcePreview not implemented";
}

bool TChannelChatBot::MaybeContinueChat(const IChatUserContext::TPtr /*context*/, const TString& /*operatorId*/, TChatContext& /* stateContext */) const {
    ythrow yexception() << "MaybeContinueChat not implemented";
}
