#pragma once

#include <drive/backend/chat_robots/channel/proto/robot_state.pb.h>

#include <drive/backend/chat_robots/abstract.h>

#include <drive/backend/database/drive_api.h>

class TChannelChatBot : public IStatefulChatRobot<NDrive::NProto::TChannelRobotState> {
public:
    using TChatRobotState = NDrive::NProto::TChannelRobotState;

private:
    using TBase = IStatefulChatRobot<NDrive::NProto::TChannelRobotState>;
    using TMessage = NDrive::NChat::TMessage;

public:
    TChannelChatBot(const NDrive::IServer* server, const TChatRobotConfig& chatConfig, const TAtomicSharedPtr<TChatViewTracker> messagesViewTracker, const TAtomicSharedPtr<TChatRobotStatePostgresStorage> robotStateStorage)
        : TBase(server, chatConfig, messagesViewTracker, robotStateStorage)
    {
    }

    virtual NThreading::TFuture<void> AcceptUserResponse(const IChatUserContext::TPtr context, const TMessage& message, const TVector<TMessageAttachment>& attachments, const TString& operatorId) const override;
    virtual void AcceptMediaResource(const IChatUserContext::TPtr context, const TString& resourceId, const TString& contentType, const TString& content, TAtomicSharedPtr<IChatMediaResourcePostUploadCallback> callback) const override;
    virtual NThreading::TFuture<TChatResourceAcquisitionResult> GetMediaResource(const IChatUserContext::TPtr context, const TString& resourceId, const bool needsFurtherProcessing) const override;
    virtual bool RegisterMediaResource(const TString& userId, const TString& resourceId, const TString& contentType, const bool shared, NDrive::TEntitySession& session) const override;
    virtual bool UpdateMediaResourceDescription(const TMediaResourceDescription description, const TString& actorUserId, NDrive::TEntitySession& session) const override;
    virtual NThreading::TFuture<void> UploadResourcePreview(const TString& content, const TMediaResourceDescription& description, const TString& contentType) const override;
    virtual bool MaybeContinueChat(const IChatUserContext::TPtr context, const TString& operatorId, TChatContext& stateContext) const override;
};
