#pragma once

#include "context.h"
#include "item_types.h"

#include <drive/backend/chat_robots/ifaces.h>
#include <drive/backend/chat_robots/suggest/node_resolver.h>

#include <rtline/util/types/accessor.h>

#include <util/generic/map.h>
#include <util/generic/vector.h>

namespace NChatRobot {
    enum EUserAction {
        NoAction /* "no_action" */,
        Button /* "button" */,
        License /* "license" */,
        Passport /* "passport" */,
        LicenseBack /* "license_back" */,
        LicenseFront /* "license_front" */,
        LicenseVideo /* "license_video" */,
        PassportBiographical /* "passport_biographical" */,
        PassportRegistration /* "passport_registration" */,
        PassportVideo /* "passport_video" */,
        LicenseSelfie /* "license_selfie" */,
        PassportSelfie /* "passport_selfie" */,
        VideoSelfie /* "video_selfie" */,
        CreditCard /* "credit_card" */,
        Call /* "call" */,
        CallResponse /* "call_response" */,
        EnterMap /* "enter_map" */,
        UserMessage /* "user_message" */,
        ChatClosed /* "chat_closed" */,
        Tree /* "tree" */,
        ContextButtons /* "context_buttons" */,
        PhoneVerificationCode /* "phone_verification_code" */,
        FeedbackCurrent /* "feedback_current" */,
        FeedbackPast /* "feedback_past" */,
        DeeplinkAction /* "deeplink" */,
        EnterPromocode /* "enter_promocode" */,
        ValidatePass /* "validate_pass" */,
        SkipAction /* "skip_action" */,
        Suggest /* "suggest" */,
        Resubmit /* "resubmit" */,
        DeviceVerificationCode /* "device_verification_code" */,
    };
};

struct TChatResourceInfo {
    TString Name;
    TString Link;
    TString ContentType;
};

class TPreActionMessage: public NDrive::NChat::TMessage {
    R_FIELD(TVector<TString>, Choices);
    R_FIELD(TChatResourceInfo, ResourceInfo);

public:
    virtual bool DoDeserializeBasicsFromJson(const NJson::TJsonValue& raw) override;
};

class TChatRobotScriptItem {
    R_FIELD(TString, Id);
    R_FIELD(NChatRobot::EUserAction, ActionType, NChatRobot::EUserAction::NoAction);
    R_FIELD(NChatRobot::EUserAction, ActionTypeInterface, NChatRobot::EUserAction::NoAction);
    R_FIELD(TString, ActionButtonText);
    R_FIELD(TVector<TPreActionMessage>, PreActionMessages);
    R_FIELD(TChatTreeSchema, Schema);
    R_FIELD(TString, FallbackNode);
    R_FIELD(TString, SupportLineTag, "support_chat_2_line");
    R_FIELD(bool, PutTagOnEntry, false);
    R_FIELD(bool, SuppressSupportCall, false);
    R_FIELD(bool, MoveSupportCall, false);
    R_FIELD(TVector<NDrive::NChat::TMessage::EMessageType>, AllowedMessageTypes);
    R_FIELD(TVector<IHookAction::TPtr>, OnEntryActions);
    R_FIELD(TCaseCondition, NextSteps);
    R_FIELD(TString, Link);
    R_FIELD(bool, UseClassifier, false);
    R_FIELD(INodeResolver::TPtr, NodeResolver, nullptr);
    R_FIELD(TVector<TContextMapInfo>, ContextMapInfo);
    R_FIELD(TJsonMapper, JsonMapper);
    R_FIELD(NJson::TJsonValue, ActionReport, NJson::JSON_NULL);
    R_FIELD(bool, UseRecognition, false);
    //
    R_FIELD(bool, Skippable, false);

    // Feedback only
    R_FIELD(TCaseCondition, NextStepsIncorrect);
    R_FIELD(TCaseCondition, NextStepsNoBonus);
    R_FIELD(TString, FeedbackTag);

    R_FIELD(TCaseCondition, NextStepsError);
    R_FIELD(TCaseCondition, NextStepsIncorrectDate);
    R_FIELD(TCaseCondition, NextStepsIncorrectPass);

    // resubmit
    R_FIELD(TString, ResubmitDocuments);

public:
    TChatRobotScriptItem() = default;

    bool Parse(const NJson::TJsonValue& raw, TMessagesCollector& errors);
    bool ParseNextStep(const NJson::TJsonValue& raw, TMessagesCollector& errors);

    bool GetTemplateImpl(const TString& nodeName, const TVector<TString>& params, TChatRobotScriptItem& result) const;

    TSet<TString> GetAdjacentItems() const;

    bool HasFurtherSteps() const {
        return NextSteps.HasFurtherSteps();
    }

    bool HasPreEntryActions() const {
        return OnEntryActions.size();
    }

    bool HasContextSettings() const {
        return !ContextMapInfo.empty();
    }

    bool GetBareId(TString& result) const;

    [[nodiscard]] bool SaveFieldsToContext(TChatContext& chatContext, const IChatUserContext::TPtr ctx) const;
    void AddSpecialValueToContext(TChatContext& chatContext, const EContextDataType type, const TString& value) const;
private:
    void ProcessAdjacentItem(const TString& raw, const TVector<TString>& params, TSet<TString>& result) const;
};
