#include "media_resource.h"

bool TMediaResourceDescription::Parse(const NStorage::TTableRecord& row) {
    Id = row.Get("id");
    ContentType = row.Get("content_type");
    UserId = row.Get("user_id");

    TString registeredAtStr = row.Get("registered_at");
    if (registeredAtStr) {
        ui64 registeredAtTimestamp = 0;
        if (!TryFromString(registeredAtStr, registeredAtTimestamp)) {
            return false;
        }
        RegisteredAt = TInstant::Seconds(registeredAtTimestamp);
    }

    TString uploadedAtStr = row.Get("uploaded_at");
    if (uploadedAtStr) {
        ui64 uploadedAtTimestamp = 0;
        if (!TryFromString(uploadedAtStr, uploadedAtTimestamp)) {
            return false;
        }
        UploadedAt = TInstant::Seconds(uploadedAtTimestamp);
    }

    HasPreview = (row.Get("has_preview") == "1") || (row.Get("has_preview") == "t");
    Shared = (row.Get("shared") == "1") || (row.Get("shared") == "t");

    return true;
}

bool TMediaResourceDescription::DeserializeWithDecoder(const TMediaResourceDescriptionDecoder& decoder, const TConstArrayRef<TStringBuf>& values, const IHistoryContext* /*hContext*/) {
    READ_DECODER_VALUE(decoder, values, Id);
    READ_DECODER_VALUE(decoder, values, ContentType);
    READ_DECODER_VALUE(decoder, values, UserId);
    READ_DECODER_VALUE_INSTANT(decoder, values, RegisteredAt);
    READ_DECODER_VALUE_INSTANT(decoder, values, UploadedAt);
    READ_DECODER_VALUE_DEF(decoder, values, HasPreview, false);
    READ_DECODER_VALUE_DEF(decoder, values, Shared, false);
    return true;
}

TString TMediaResourceDescription::GetObjectId(const TMediaResourceDescription& object) {
    return object.GetId();
}

NStorage::TTableRecord TMediaResourceDescription::SerializeToTableRecord() const {
    NStorage::TTableRecord result;
    result.Set("id", Id);
    result.Set("content_type", ContentType);
    result.Set("user_id", UserId);
    result.Set("registered_at", RegisteredAt.Seconds());
    result.Set("uploaded_at", UploadedAt.Seconds());
    result.Set("has_preview", HasPreview);
    result.Set("shared", Shared);
    return result;
}

TString TMediaResourceDescription::BuildPath() const {
    return UserId + "/" + Id;
}

TString TMediaResourceDescription::BuildPreviewPath() const {
    return UserId + "/" + Id + "_preview";
}
