
#pragma once

#include <rtline/library/storage/structured.h>

#include <rtline/util/json_processing.h>
#include <rtline/util/types/accessor.h>

#include <util/memory/blob.h>

class TMediaResourceDescription {
    R_READONLY(TString, Id);
    R_FIELD(TString, ContentType);
    R_READONLY(TString, UserId);
    R_READONLY(TInstant, RegisteredAt);
    R_FIELD(TInstant, UploadedAt);
    R_FIELD(bool, HasPreview, false);
    R_FIELD(bool, Shared, false);

public:
    class TMediaResourceDescriptionDecoder: public TBaseDecoder {
        R_FIELD(i32, Id, -1);
        R_FIELD(i32, ContentType, -1);
        R_FIELD(i32, UserId, -1);
        R_FIELD(i32, RegisteredAt, -1);
        R_FIELD(i32, UploadedAt, -1);
        R_FIELD(i32, HasPreview, -1);
        R_FIELD(i32, Shared, -1);

    public:
        TMediaResourceDescriptionDecoder() = default;

        TMediaResourceDescriptionDecoder(const TMap<TString, ui32>& decoderBase) {
            Id = GetFieldDecodeIndex("id", decoderBase);
            ContentType = GetFieldDecodeIndex("content_type", decoderBase);
            UserId = GetFieldDecodeIndex("user_id", decoderBase);
            RegisteredAt = GetFieldDecodeIndex("registered_at", decoderBase);
            UploadedAt = GetFieldDecodeIndex("uploaded_at", decoderBase);
            HasPreview = GetFieldDecodeIndex("has_preview", decoderBase);
            Shared = GetFieldDecodeIndex("shared", decoderBase);
        }
    };

    using TDecoder = TMediaResourceDescriptionDecoder;

    TMediaResourceDescription() = default;

    TMediaResourceDescription(const TString& id, const TString& userId)
        : Id(id)
        , UserId(userId)
        , RegisteredAt(Now())
    {
    }

    bool DeserializeWithDecoder(const TMediaResourceDescriptionDecoder& decoder, const TConstArrayRef<TStringBuf>& values, const IHistoryContext* /*hContext*/);
    static TString GetObjectId(const TMediaResourceDescription& object);

    bool Parse(const NStorage::TTableRecord& row);
    NStorage::TTableRecord SerializeToTableRecord() const;

    TString BuildPath() const;
    TString BuildPreviewPath() const;
};

class TChatResourceAcquisitionResult {
    R_FIELD(TBlob, Content);
    R_FIELD(TMediaResourceDescription, Description);
    R_FIELD(TString, Location);
    R_FIELD(TString, PreviewType);
    R_FIELD(bool, Generated, false);

public:
    TChatResourceAcquisitionResult(const TBlob& content, const TMediaResourceDescription& description, const TString& location = {})
        : Content(content)
        , Description(description)
        , Location(location)
    {
    }
};
