#pragma once

#include <drive/backend/chat_robots/simple.h>
#include <drive/backend/chat_robots/state/robot_state.pb.h>

#include <drive/backend/database/drive_api.h>
#include <drive/backend/registrar/ifaces.h>
#include <drive/backend/user_document_photos/manager.h>

class TRegistrationChatBot : public TSimpleChatBot {
public:
    using TChatRobotState = NChatRobotState::TChatRobotState;

private:
    using TBase = TSimpleChatBot;
    using TMessage = NDrive::NChat::TMessage;

    bool SetInitialAction(const TString& userId, const ui32 chatRoomId, const TString& actionId, NDrive::TEntitySession& session, const ui32 queuedResubmit = 0) const;
    virtual bool DeduceChatContinuation(const TString& userId, const TString& topic, const ui32 chatRoomId, NDrive::TEntitySession& session) const override;
    bool DeduceBlockedChatContinuation(const TString& userId, const ui32 chatRoom, NDrive::TEntitySession& session) const;

public:
    using TBase::TBase;

    virtual TString GetChatTitle(const NDrive::NChat::TChat& chat) const override {
        return chat.GetTitle() ? chat.GetTitle() : "Регистрация";
    }

    virtual void CheckIn(const TString& userId, const TString& operatorUserId, const TString& topic, const TString& origin, const TString& externalUserId, const TGeoCoord* location, TInstant actuality) const override;
};
