#include "light.h"

#include <drive/backend/data/user_origin.h>

void TLightRegistrationChatBot::CheckIn(const TString& userId, const TString& operatorUserId, const TString& topic, const TString& origin, const TString& externalUserId, const TGeoCoord* location, TInstant actuality) const {
    Y_UNUSED(operatorUserId);
    Y_UNUSED(topic);
    Y_UNUSED(location);
    Y_UNUSED(actuality);
    auto session = Server->GetDriveAPI()->template BuildTx<NSQL::Writable>();
    if (externalUserId || origin) {
        if (!TUserOriginTag::Set(userId, origin, externalUserId, *Server, session)) {
            ERROR_LOG << "LightRegistrationChatBot::CheckIn: cannot set user origin: " << session.GetStringReport() << Endl;
        }
    }
    if (!session.Commit()) {
        ERROR_LOG << "LightRegistrationChatBot::CheckIn: cannot commit: " << session.GetStringReport() << Endl;
    }
}
