#pragma once

#include "abstract.h"
#include "media_storage.h"

#include <drive/backend/chat_robots/configuration/config.h>
#include <drive/backend/offers/offers/abstract.h>

class TChatRobotsManager final : public IMessageProcessor {
public:
    TChatRobotsManager(const NDrive::IServer* server, const TChatRobotsConfig& robotsConfig);
    virtual ~TChatRobotsManager();

    IChatRobot::TPtr GetChatRobot(const TString& name) const;

    virtual const TSimpleUnencryptedMediaStorage* GetChatRobotsMediaStorage() const;
    virtual const TAtomicSharedPtr<TChatViewTracker> GetChatViewTracker() const;
    virtual const TAtomicSharedPtr<TChatRobotStatePostgresStorage> GetChatRobotStateStorage() const;
    virtual const TMap<TString, IChatRobot::TPtr> GetChatRobots() const;

    virtual bool RegisterChatRobot(const TChatRobotConfig& config) const;
    virtual bool UnregisterChatRobot(const TString& robotId) const;

    virtual TString Name() const override;

private:
    const NDrive::IServer* Server;

    mutable TMap<TString, IChatRobot::TPtr> ChatRobots;

    TRWMutex MutexChatRobots;
    TAtomicSharedPtr<TChatRobotStatePostgresStorage> ChatRobotStateStorage;
    TAtomicSharedPtr<TCallbackSequentialTableImpl<TObjectEvent<TMediaResourceDescription>, TString>> ChatMediaHistoryReader;
    TAtomicSharedPtr<TSimpleUnencryptedMediaStorage> ChatRobotMediaStorage;
    TAtomicSharedPtr<TCallbackSequentialTableImpl<TObjectEvent<TViewTrackerState>, ui32>> ChatViewTrackerHistoryReader;
    TAtomicSharedPtr<TChatViewTracker> ChatViewTracker;

    virtual bool Process(IMessage* message) override;
    virtual void HandleOfferBookingEvent(const ICommonOffer::TPtr offer) const;
};
