#include "button.h"

TMaybe<TString> TButtonScriptAction::AcceptMessage(const TNextActionInfo& actionInfo, TChatContext& stateContext, NDrive::TEntitySession& chatSession, NDrive::TEntitySession& tagsSession) const {
    Y_UNUSED(tagsSession);
    Y_UNUSED(actionInfo);
    NDrive::NChat::TMessage chatMessage;
    chatMessage.SetType(NDrive::NChat::TMessage::EMessageType::Plaintext);
    chatMessage.SetText(GetCurrentScriptItem().GetActionButtonText());
    if (!AcceptRegularMessage(chatMessage, {}, stateContext, chatSession)) {
        return Nothing();
    }
    return "";
}
