#include "call.h"
#include <drive/backend/database/drive_api.h>

TMaybe<TString> TCallScriptAction::AcceptMessage(const TNextActionInfo& actionInfo, TChatContext& stateContext, NDrive::TEntitySession& chatSession, NDrive::TEntitySession& tagsSession) const {
    Y_UNUSED(actionInfo);
    auto tag = IJsonSerializableTag::BuildWithComment<TUserRobotCallTag>("registration_robot_call", "Звонок робота регистрации");
    if (!GetContext()->GetServer().GetDriveAPI()->GetTagsManager().GetUserTags().AddTag(tag, GetContext()->GetChatRobot()->GetChatConfig().GetRobotUserId(), GetContext()->GetUserId(), &GetContext()->GetServer(), tagsSession)) {
        return Nothing();
    }
    NDrive::NChat::TMessage chatMessage;
    chatMessage.SetType(NDrive::NChat::TMessage::EMessageType::Plaintext);
    chatMessage.SetText(GetCurrentScriptItem().GetActionButtonText());
    if (!AcceptRegularMessage(chatMessage, {}, stateContext, chatSession)) {
        return Nothing();
    }
    return "";
}

TMaybe<TString> TCallResponseScriptAction::AcceptMessage(const TNextActionInfo& actionInfo, TChatContext& stateContext, NDrive::TEntitySession& chatSession, NDrive::TEntitySession& tagsSession) const {
    Y_UNUSED(tagsSession);
    Y_UNUSED(actionInfo);
    Y_UNUSED(chatSession);
    Y_UNUSED(stateContext);
    return "";
}
