#pragma once

#include "script_action.h"

class TCallScriptAction: public IChatScriptAction {
private:
    using TBase = IChatScriptAction;

public:
    using TBase::TBase;

protected:
    virtual TMaybe<TString> AcceptMessage(const TNextActionInfo& actionInfo, TChatContext& stateContext, NDrive::TEntitySession& chatSession, NDrive::TEntitySession& tagsSession) const override;

private:
    static inline TFactory::TRegistrator<TCallScriptAction> Registrator{NChatRobot::EUserAction::Call};
};

class TCallResponseScriptAction: public IChatScriptAction {
private:
    using TBase = IChatScriptAction;

public:
    using TBase::TBase;

protected:
    virtual TMaybe<TString> AcceptMessage(const TNextActionInfo& actionInfo, TChatContext& stateContext, NDrive::TEntitySession& chatSession, NDrive::TEntitySession& tagsSession) const override;

private:
    static inline TFactory::TRegistrator<TCallResponseScriptAction> Registrator{NChatRobot::EUserAction::CallResponse};
};
