#include "credit_card.h"

#include <drive/backend/billing/manager.h>
#include <drive/backend/billing/trust/charge_logic.h>

TMaybe<TString> TCreditCardScriptAction::AcceptMessage(const TNextActionInfo& actionInfo, TChatContext& stateContext, NDrive::TEntitySession& chatSession, NDrive::TEntitySession& tagsSession) const {
    auto trustLogic = GetContext()->GetServer().GetDriveAPI()->GetBillingManager().GetLogicByType(NDrive::NBilling::EAccount::Trust);
    if (!trustLogic) {
        chatSession.SetErrorInfo("TCreditCardScriptAction::AcceptMessage", "no trust logic");
        return Nothing();
    }
    auto trustAccount = GetContext()->GetServer().GetDriveAPI()->GetBillingManager().GetAccountsManager().GetOrCreateTrustAccount(GetContext()->GetUserId(), GetContext()->GetUserId(), tagsSession);
    if (!trustAccount) {
        return Nothing();
    }
    auto trustLogicImpl = trustLogic->GetAsSafe<TTrustLogic>();
    if (!trustLogicImpl) {
        chatSession.SetErrorInfo("TCreditCardScriptAction::AcceptMessage", "cannot cast trust logic");
        return Nothing();
    }
    auto bindResult = trustLogicImpl->SetDefaultCard(trustAccount, actionInfo.GetMessage().GetText(), GetContext()->GetUserId(), tagsSession);
    if (!bindResult.Defined()) {
        return Nothing();
    }
    NDrive::NChat::TMessage usersResponse;
    usersResponse.SetType(NDrive::NChat::TMessage::EMessageType::CreditCardBinding);
    usersResponse.SetText(bindResult->GetAccount());
    if (!AcceptRegularMessage(usersResponse, actionInfo.GetAttachments(), stateContext, chatSession, false, false)) {
        return Nothing();
    }
    auto nextStepWithResubmit = GetContext()->GetChatRobot()->GetNextResubmitStep(GetContext(), GetCurrentScriptItem(), stateContext, chatSession);
    if (!nextStepWithResubmit) {
        return Nothing();
    }
    if (!nextStepWithResubmit->GetMessage().GetText().empty() && !AcceptRegularMessage(nextStepWithResubmit->GetMessage(), nextStepWithResubmit->GetAttachments(), stateContext, chatSession, false, true)) {
        return Nothing();
    }
    return nextStepWithResubmit->GetNextNodeId().empty() ? actionInfo.GetNextNodeId() : nextStepWithResubmit->GetNextNodeId();
}
