#pragma once

#include "script_action.h"

class IDocumentScriptAction: public IChatScriptAction {
private:
    using TBase = IChatScriptAction;

public:
    using TBase::TBase;

protected:
    virtual NThreading::TFuture<TNextActionInfo> ProcessAsyncOperations(const NDrive::NChat::TMessage& message, const TVector<TMessageAttachment>& attachments) const override;
    virtual TMaybe<TString> AcceptMessage(const TNextActionInfo& actionInfo, TChatContext& stateContext, NDrive::TEntitySession& chatSession, NDrive::TEntitySession& tagsSession) const override;
    virtual NDrive::NChat::TMessage::EMessageType GetMessageType() const = 0;
    virtual TMaybe<NUserDocument::EType> GetDocumentType(NChatRobot::EUserAction actionType, size_t attachmentNumber) const = 0;
};

class TSingleDocumentScriptAction: public IDocumentScriptAction {
private:
    using TBase = IDocumentScriptAction;
public:
    using TBase::TBase;

protected:
    virtual NDrive::NChat::TMessage::EMessageType GetMessageType() const override;
    virtual TMaybe<NUserDocument::EType> GetDocumentType(NChatRobot::EUserAction actionType, size_t attachmentNumber) const override;
};

class TDocumentVideoAction: public IDocumentScriptAction {
private:
    using TBase = IDocumentScriptAction;
public:
    using TBase::TBase;

protected:
    virtual NDrive::NChat::TMessage::EMessageType GetMessageType() const override;
    virtual TMaybe<NUserDocument::EType> GetDocumentType(NChatRobot::EUserAction actionType, size_t attachmentNumber) const override;
};

class ICompleteDocumentScriptAction: public IDocumentScriptAction {
private:
    using TBase = IDocumentScriptAction;
public:
    using TBase::TBase;

protected:
    virtual NDrive::NChat::TMessage::EMessageType GetMessageType() const override;
};


class TCompleteLicenseScriptAction: public ICompleteDocumentScriptAction {
private:
    using TBase = ICompleteDocumentScriptAction;
public:
    using TBase::TBase;

protected:
    virtual TMaybe<NUserDocument::EType> GetDocumentType(NChatRobot::EUserAction actionType, size_t attachmentNumber) const override;

private:
    static inline TFactory::TRegistrator<TCompleteLicenseScriptAction> Registrator{NChatRobot::EUserAction::License};
};

class TCompletePassportScriptAction: public ICompleteDocumentScriptAction {
private:
    using TBase = ICompleteDocumentScriptAction;
public:
    using TBase::TBase;

protected:
    virtual TMaybe<NUserDocument::EType> GetDocumentType(NChatRobot::EUserAction actionType, size_t attachmentNumber) const override;

private:
    static inline TFactory::TRegistrator<TCompletePassportScriptAction> Registrator{NChatRobot::EUserAction::Passport};
};
