#pragma once

#include "script_action.h"

class IFeedbackScriptAction: public IChatScriptAction {
private:
    using TBase = IChatScriptAction;

public:
    using TBase::TBase;

protected:
    virtual TMaybe<TString> AcceptMessage(const TNextActionInfo& actionInfo, TChatContext& stateContext, NDrive::TEntitySession& chatSession, NDrive::TEntitySession& tagsSession) const override;
    virtual bool FindSessionAndDevice(const TString& messageText, TString& sessionId, TString& deviceId, NDrive::TEntitySession& tagsSession) const = 0;
};

class TCurrentFeedbackScriptAction: public IFeedbackScriptAction {
private:
    using TBase = IFeedbackScriptAction;
public:
    using TBase::TBase;

    static NChatRobot::EUserAction GetType() {
        return NChatRobot::EUserAction::FeedbackCurrent;
    }

protected:
    virtual bool FindSessionAndDevice(const TString& messageText, TString& sessionId, TString& deviceId, NDrive::TEntitySession& tagsSession) const override;

private:
    static TFactory::TRegistrator<TCurrentFeedbackScriptAction> Registrator;
};

class TPastFeedbackScriptAction: public IFeedbackScriptAction {
private:
    using TBase = IFeedbackScriptAction;
public:
    using TBase::TBase;

    static NChatRobot::EUserAction GetType() {
        return NChatRobot::EUserAction::FeedbackPast;
    }

protected:
    virtual bool FindSessionAndDevice(const TString& messageText, TString& sessionId, TString& deviceId, NDrive::TEntitySession& tagsSession) const override;

private:
    static TFactory::TRegistrator<TPastFeedbackScriptAction> Registrator;
};
