#pragma once

#include "script_action.h"

class IOptionsScriptAction: public IChatScriptAction {
private:
    using TBase = IChatScriptAction;

public:
    using TBase::TBase;

protected:
    virtual TMaybe<TString> AcceptMessage(const TNextActionInfo& actionInfo, TChatContext& stateContext, NDrive::TEntitySession& chatSession, NDrive::TEntitySession& tagsSession) const override;
};

class TTreeScriptAction: public IOptionsScriptAction {
private:
    using TBase = IOptionsScriptAction;
public:
    using TBase::TBase;

    static NChatRobot::EUserAction GetType() {
        return NChatRobot::EUserAction::Tree;
    }

private:
    static TFactory::TRegistrator<TTreeScriptAction> Registrator;
};

class TContextButtonScriptAction: public IOptionsScriptAction {
private:
    using TBase = IOptionsScriptAction;
public:
    using TBase::TBase;

    static NChatRobot::EUserAction GetType() {
        return NChatRobot::EUserAction::ContextButtons;
    }

private:
    static TFactory::TRegistrator<TContextButtonScriptAction> Registrator;
};
