#pragma once

#include "script_action.h"

class IVerificationScriptAction: public IChatScriptAction {
private:
    using TBase = IChatScriptAction;
public:
    using TBase::TBase;

protected:
    virtual TMaybe<TString> AcceptMessage(const TNextActionInfo& actionInfo, TChatContext& stateContext, NDrive::TEntitySession& chatSession, NDrive::TEntitySession& tagsSession) const override;

private:
    virtual TMaybe<bool> AcceptCode(const TString& code, TSet<TString>& errorCodes, NDrive::TEntitySession& tagsSession) const = 0;
};

class TPhoneVerificationScriptAction: public IVerificationScriptAction {
private:
    using TBase = IVerificationScriptAction;
public:
    using TBase::TBase;

    static NChatRobot::EUserAction GetType() {
        return NChatRobot::EUserAction::PhoneVerificationCode;
    }

protected:
    TMaybe<bool> AcceptCode(const TString& code, TSet<TString>& errorCodes, NDrive::TEntitySession& tagsSession) const override;

private:
    static TFactory::TRegistrator<TPhoneVerificationScriptAction> Registrator;
};

class TDeviceVerificationScriptAction: public IVerificationScriptAction {
private:
    using TBase = IVerificationScriptAction;
public:
    using TBase::TBase;

    static NChatRobot::EUserAction GetType() {
        return NChatRobot::EUserAction::DeviceVerificationCode;
    }

protected:
    TMaybe<bool> AcceptCode(const TString& code, TSet<TString>& errorCodes, NDrive::TEntitySession& tagsSession) const override;

private:
    static TFactory::TRegistrator<TDeviceVerificationScriptAction> Registrator;
};
