#include "promocode.h"

#include <drive/backend/promo_codes/manager.h>
#include <drive/backend/database/drive_api.h>

IChatScriptAction::TFactory::TRegistrator<TEnterPromocodeScriptAction> TEnterPromocodeScriptAction::Registrator(TEnterPromocodeScriptAction::GetType());

NThreading::TFuture<TNextActionInfo> TEnterPromocodeScriptAction::ProcessAsyncOperations(const NDrive::NChat::TMessage& message, const TVector<TMessageAttachment>& attachments) const {
    Y_UNUSED(attachments);
    if (!GetContext()->GetServer().GetPromoCodesManager()) {
        return NThreading::TExceptionFuture() << "TEnterPromocodeScriptAction::ProcessAsyncOperations promocode manager not configured";
    }
    if (!GetContext()->GetUserPermissions()) {
        return NThreading::TExceptionFuture() << "TEnterPromocodeScriptAction::ProcessAsyncOperation scannot get user permissions from TChatUserContext";
    }
    TNextActionInfo result;
    NJson::TJsonValue report;
    TString promocode = StripString(message.GetText());
    result.SetMessage(message);
    {
        auto tagsSession = GetContext()->GetServer().GetDriveAPI()->template BuildTx<NSQL::Writable | NSQL::RepeatableRead>();
        if (GetContext()->GetServer().GetChatEngine()->GetDatabaseName() != GetContext()->GetServer().GetDriveAPI()->GetDatabaseName()) {
            auto chatSession = GetContext()->GetServer().GetChatEngine()->BuildSession(false);
            if (!GetContext()->GetServer().GetPromoCodesManager()->ApplyCode(promocode, GetContext()->GetUserId(), GetContext()->GetUserPermissions(), report, tagsSession, chatSession) || !chatSession.Commit()) {
                NDrive::TEventLog::Log("TEnterPromocodeScriptAction::ProcessAsyncOperations", NJson::TMapBuilder
                    ("user_id", GetContext()->GetUserId())
                    ("promocode", message.GetText())
                    ("chat_errors", chatSession.GetReport())
                    ("errors", tagsSession.GetReport())
                );
                result.SetFailed(true);
            }
        } else if (!GetContext()->GetServer().GetPromoCodesManager()->ApplyCode(promocode, GetContext()->GetUserId(), GetContext()->GetUserPermissions(), report, tagsSession, tagsSession)) {
            result.SetFailed(true);
            NDrive::TEventLog::Log("TEnterPromocodeScriptAction::ProcessAsyncOperations", NJson::TMapBuilder
                ("user_id", GetContext()->GetUserId())
                ("promocode", message.GetText())
                ("errors", tagsSession.GetReport())
            );
        }
        if (!result.IsFailed() && !tagsSession.Commit()) {
            result.SetFailed(true);
            NDrive::TEventLog::Log("TEnterPromocodeScriptAction::ProcessAsyncOperations", NJson::TMapBuilder
                ("user_id", GetContext()->GetUserId())
                ("promocode", message.GetText())
                ("errors", tagsSession.GetReport())
            );
        }
    }
    return NThreading::MakeFuture(result);
}

TMaybe<TString> TEnterPromocodeScriptAction::AcceptMessage(const TNextActionInfo& actionInfo, TChatContext& stateContext, NDrive::TEntitySession& chatSession, NDrive::TEntitySession& tagsSession) const {
    Y_UNUSED(tagsSession);
    if (!AcceptRegularMessage(actionInfo.GetMessage(), actionInfo.GetAttachments(), stateContext, chatSession)) {
        return Nothing();
    }
    if (actionInfo.GetFailed()) {
        return GetCurrentScriptItem().GetNextStepsIncorrect().GetNextNode(GetContext(), stateContext);
    } else {
        return GetCurrentScriptItem().GetNextSteps().GetNextNode(GetContext(), stateContext);
    }
}
