#include "resubmit.h"

TMaybe<TString> TResubmitScriptAction::AcceptMessage(const TNextActionInfo& actionInfo, TChatContext& stateContext, NDrive::TEntitySession& chatSession, NDrive::TEntitySession& tagsSession) const {
    Y_UNUSED(tagsSession);
    Y_UNUSED(actionInfo);
    Y_UNUSED(stateContext);
    chatSession.SetErrorInfo("TResubmitScriptAction::AcceptMessage", "user should not be able to send messages to resubmit node");
    return Nothing();
}

bool TResubmitScriptAction::OnEnter(const ui32 chatRoomId, TChatContext& stateContext, NDrive::TEntitySession& chatSession, NDrive::TEntitySession& tagsSession, TString& nextNodeId, const bool sendMessages, const TMaybe<ui64> lastMessageId) const {
    if (!TBase::OnEnter(chatRoomId, stateContext, chatSession, tagsSession, nextNodeId, sendMessages, lastMessageId) || !TBase::OnExit(AddTag, stateContext, chatSession, tagsSession)) {
        return false;
    }

    TSet<TString> resubmitTypes = MakeSet(SplitString(GetCurrentScriptItem().GetResubmitDocuments(), ","));
    if (resubmitTypes.empty()) {
        return true;
    }
    ui32 resubmitMask = 0;
    for (auto&& resubmitType : resubmitTypes) {
        NUserDocument::EType eType;
        if (TryFromString(resubmitType, eType)) {
            resubmitMask |= eType;
        } else {
            chatSession.SetErrorInfo("TResubmitScriptAction::OnEnter", "incorrect document type " + resubmitType);
            return false;
        }
    }

    auto nextStepWithResubmit = GetContext()->GetChatRobot()->GetFirstResubmitStep(GetContext(), stateContext, chatSession, resubmitMask);
    if (!nextStepWithResubmit) {
        return false;
    }
    if (!nextStepWithResubmit->GetMessage().GetText().empty() && !AcceptRegularMessage(nextStepWithResubmit->GetMessage(), nextStepWithResubmit->GetAttachments(), stateContext, chatSession, false, true)) {
        return false;
    }
    nextNodeId = nextStepWithResubmit->GetNextNodeId();
    if (nextNodeId) {
        TMaybe<TChatRobotScriptItem> nextScriptItem = GetContext()->GetChatRobot()->GetChatConfig().GetChatScript().GetScriptItemById(nextNodeId);
        if (!nextScriptItem) {
            chatSession.SetErrorInfo("TResubmitScriptAction::OnEnter", "cannot find script item for " + nextNodeId);
            return false;
        }
        if (auto nextScriptActions = IChatScriptAction::Construct(GetContext(), *nextScriptItem, GetOperatorId())) {
            if (!nextScriptActions->OnEnter(chatRoomId, stateContext, chatSession, tagsSession, nextNodeId, sendMessages)) {
                return false;
            }
        } else {
            chatSession.SetErrorInfo("TResubmitScriptAction::OnEnter", "cannot construct action " + ToString(nextScriptItem->GetActionType()));
            return false;
        }
    }
    return true;
}
